-- -------------------------------------------
SET AUTOCOMMIT=0;
START TRANSACTION;
SET SQL_QUOTE_SHOW_CREATE = 1;
SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
-- -------------------------------------------
-- -------------------------------------------
-- START BACKUP
-- -------------------------------------------
-- -------------------------------------------
-- TABLE `Dictionary`
-- -------------------------------------------
DROP TABLE IF EXISTS `Dictionary`;
CREATE TABLE IF NOT EXISTS `Dictionary` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `ParentId` int(11) DEFAULT NULL,
  `Code` varchar(50) DEFAULT NULL,
  `Text` varchar(50) DEFAULT NULL,
  `SeqNum` int(11) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1;

-- -------------------------------------------
-- TABLE `IMSrate6`
-- -------------------------------------------
DROP TABLE IF EXISTS `IMSrate6`;
CREATE TABLE IF NOT EXISTS `IMSrate6` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `npanxx` int(11) NOT NULL,
  `ratectr` varchar(64) NOT NULL,
  `intrastate` float NOT NULL,
  `interstate` float NOT NULL,
  `initial` int(11) NOT NULL,
  `increment` int(11) NOT NULL DEFAULT '1',
  `effective` varchar(100) NOT NULL,
  `lata` int(11) DEFAULT NULL,
  `ocn` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;

-- -------------------------------------------
-- TABLE `actions_log`
-- -------------------------------------------
DROP TABLE IF EXISTS `actions_log`;
CREATE TABLE IF NOT EXISTS `actions_log` (
  `action_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `user_type` varchar(400) COLLATE utf8_unicode_ci NOT NULL,
  `action_name` varchar(400) COLLATE utf8_unicode_ci NOT NULL,
  `object` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `object_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `action_comment` int(11) NOT NULL,
  `action_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`action_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- -------------------------------------------
-- TABLE `admin_permissions`
-- -------------------------------------------
DROP TABLE IF EXISTS `admin_permissions`;
CREATE TABLE IF NOT EXISTS `admin_permissions` (
  `admin_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  PRIMARY KEY (`admin_id`,`permission_id`),
  KEY `permission_id` (`permission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- -------------------------------------------
-- TABLE `admin_permissions_types`
-- -------------------------------------------
DROP TABLE IF EXISTS `admin_permissions_types`;
CREATE TABLE IF NOT EXISTS `admin_permissions_types` (
  `permission_id` int(11) NOT NULL,
  `permission_name` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`permission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- -------------------------------------------
-- TABLE `admin_service`
-- -------------------------------------------
DROP TABLE IF EXISTS `admin_service`;
CREATE TABLE IF NOT EXISTS `admin_service` (
  `serviceid` int(11) NOT NULL AUTO_INCREMENT,
  `servicename` varchar(50) DEFAULT NULL,
  `setupfee` float DEFAULT NULL,
  `priceperminute` float DEFAULT NULL,
  `monthlyfee` float DEFAULT NULL,
  PRIMARY KEY (`serviceid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- -------------------------------------------
-- TABLE `admin_services`
-- -------------------------------------------
DROP TABLE IF EXISTS `admin_services`;
CREATE TABLE IF NOT EXISTS `admin_services` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(55) NOT NULL,
  `value` varchar(55) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1;

-- -------------------------------------------
-- TABLE `admins`
-- -------------------------------------------
DROP TABLE IF EXISTS `admins`;
CREATE TABLE IF NOT EXISTS `admins` (
  `admin_id` int(18) NOT NULL AUTO_INCREMENT,
  `username` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `fname` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `lname` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `province` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `zipcode` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel1` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel2` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobile` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `notes` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`admin_id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1;

-- -------------------------------------------
-- TABLE `carrier_ratesheets`
-- -------------------------------------------
DROP TABLE IF EXISTS `carrier_ratesheets`;
CREATE TABLE IF NOT EXISTS `carrier_ratesheets` (
  `ratesheet_id` int(11) NOT NULL AUTO_INCREMENT,
  `ratesheet_name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `ratesheet_table` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `carrier_id` int(11) NOT NULL,
  PRIMARY KEY (`ratesheet_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- -------------------------------------------
-- TABLE `cdrs`
-- -------------------------------------------
DROP TABLE IF EXISTS `cdrs`;
CREATE TABLE IF NOT EXISTS `cdrs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `callid` char(64) NOT NULL DEFAULT '',
  `sip_code` char(3) NOT NULL DEFAULT '',
  `sip_reason` char(32) NOT NULL DEFAULT '',
  `time` datetime NOT NULL,
  `duration` int(11) unsigned NOT NULL DEFAULT '0',
  `setuptime` datetime NOT NULL,
  `caller_no` varchar(64) DEFAULT NULL,
  `callee_no` varchar(64) DEFAULT NULL,
  `lnp` varchar(64) DEFAULT NULL,
  `translated_caller_no` varchar(64) DEFAULT NULL,
  `translated_callee_no` varchar(64) DEFAULT NULL,
  `in_addrport` varchar(64) DEFAULT NULL,
  `out_addrport` varchar(64) DEFAULT NULL,
  `in_rg` int(11) DEFAULT NULL,
  `out_rg` int(11) DEFAULT NULL,
  `isup_oli` varchar(3) DEFAULT NULL,
  `disconnect_side` varchar(20) DEFAULT NULL,
  `npanxx` int(11) NOT NULL,
  `cname` varchar(64) NOT NULL,
  `belongs_to` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `cost` double NOT NULL,
  `ratectr` varchar(64) NOT NULL,
  `lata` int(11) NOT NULL,
  `ocn` varchar(300) NOT NULL,
  `vendor_id` int(11) NOT NULL,
  `carrier_id` char(64) NOT NULL,
  `server_ip` varchar(300) NOT NULL,
  `rate` double NOT NULL DEFAULT '0',
  `connection_fee` double NOT NULL DEFAULT '0',
  `rate_plan_name` varchar(300) NOT NULL,
  `imported` int(11) DEFAULT '0',
  `customerid` int(11) DEFAULT NULL,
  `accountcode` varchar(200) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `callid_idx` (`callid`),
  KEY `callee_no_idx` (`callee_no`),
  KEY `customerid_idx` (`customerid`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;

-- -------------------------------------------
-- TABLE `commons`
-- -------------------------------------------
DROP TABLE IF EXISTS `commons`;
CREATE TABLE IF NOT EXISTS `commons` (
  `last_cdr_id` int(11) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- -------------------------------------------
-- TABLE `countries`
-- -------------------------------------------
DROP TABLE IF EXISTS `countries`;
CREATE TABLE IF NOT EXISTS `countries` (
  `country_id` int(11) NOT NULL AUTO_INCREMENT,
  `country` varchar(50) NOT NULL,
  `countrycode` varchar(50) NOT NULL,
  `prefix` varchar(10) NOT NULL,
  `ppm` float NOT NULL,
  `carrierid` varchar(50) NOT NULL,
  `SeqNum` int(11) NOT NULL,
  PRIMARY KEY (`country_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1;

-- -------------------------------------------
-- TABLE `countries_imp`
-- -------------------------------------------
DROP TABLE IF EXISTS `countries_imp`;
CREATE TABLE IF NOT EXISTS `countries_imp` (
  `country` varchar(50) DEFAULT NULL,
  `countrycode` varchar(50) DEFAULT NULL,
  `prefix` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- -------------------------------------------
-- TABLE `customer`
-- -------------------------------------------
DROP TABLE IF EXISTS `customer`;
CREATE TABLE IF NOT EXISTS `customer` (
  `customerid` int(11) NOT NULL AUTO_INCREMENT,
  `customername` varchar(32) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `inmatenumber` varchar(50) DEFAULT NULL,
  `contactnamefirst` varchar(50) DEFAULT NULL,
  `contactnamelast` varchar(50) DEFAULT NULL,
  `contactnamemiddle` varchar(50) DEFAULT NULL,
  `location` int(11) DEFAULT NULL,
  `notes` text,
  `firstname` varchar(50) DEFAULT NULL,
  `lastname` varchar(50) DEFAULT NULL,
  `address1` varchar(200) DEFAULT NULL,
  `address2` varchar(200) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `zip` varchar(12) DEFAULT NULL,
  `phone1` varchar(50) DEFAULT NULL,
  `phone2` varchar(50) DEFAULT NULL,
  `phone3` varchar(50) DEFAULT NULL,
  `ptype1` varchar(50) DEFAULT NULL,
  `ptype2` varchar(50) DEFAULT NULL,
  `ptype3` varchar(50) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `username` varchar(50) DEFAULT NULL,
  `userpassword` varchar(255) DEFAULT NULL,
  `allowuserlogin` int(11) DEFAULT NULL,
  `billingmethod` int(11) DEFAULT NULL,
  `invoicecycle` int(11) DEFAULT NULL,
  `billstart` datetime DEFAULT NULL,
  `creditbalance` float DEFAULT NULL,
  `postpaidlimit` float DEFAULT NULL,
  `lastbilldate` datetime DEFAULT NULL,
  `postpaidbalance` float DEFAULT NULL,
  `bilemail` varchar(128) DEFAULT NULL,
  `billingtype` varchar(10) DEFAULT NULL,
  `depositbalance` float DEFAULT NULL,
  `pernumbercharges` float DEFAULT NULL,
  `freenumbers` int(11) DEFAULT NULL,
  `prepaidamount` double DEFAULT NULL,
  `accountcode` varchar(200) DEFAULT NULL,
  `carrierid` char(64) DEFAULT NULL,
  `rate_id` int(11) DEFAULT NULL,
  `hidecallerid` int(1) NOT NULL DEFAULT '1',
  `cnamerelay` int(1) NOT NULL DEFAULT '1',
  `serviceType` varchar(20) DEFAULT NULL,
  `ringType` varchar(20) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `setupfee` float DEFAULT NULL,
  `priceperminute` float DEFAULT NULL,
  `monthlyfee` float DEFAULT NULL,
  `allowcredit` int(11) NOT NULL DEFAULT '0',
  `numberamount` float DEFAULT NULL,
  `contactnumber` varchar(20) DEFAULT NULL,
  `skypeid` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `province` varchar(255) DEFAULT NULL,
  `customer_profile_id` int(11) DEFAULT NULL,
  `customerPaymentProfileId` int(11) DEFAULT NULL,
  `customerAddressId` int(11) DEFAULT NULL,
  `recurring_payment` varchar(2) DEFAULT NULL,
  `total_minutes` float DEFAULT NULL,
  `limitamount` int(11) NOT NULL DEFAULT '0',
  `notification_status` int(11) NOT NULL DEFAULT '0',
  `role` varchar(55) DEFAULT NULL,
  `check` int(11) DEFAULT NULL,
  `addtime` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `facchangetime` datetime DEFAULT NULL,
  `admin_id` int(11) DEFAULT NULL,
  `inmateStatus` varchar(50) NOT NULL,
  `paymentStatus` varchar(50) NOT NULL,
  `supportStatus` varchar(50) NOT NULL,
  PRIMARY KEY (`customerid`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1;

