<?php

class CountriesController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','stateindex','stateadmin','states','cityindex','cities','suggestZip',),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}



	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Countries');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}
	public function actionStateindex()
	{
		$dataProvider=new CActiveDataProvider('States');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}
	public function actionCityindex()
	{
		$dataProvider=new CActiveDataProvider('Cities');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}
	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Countries('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Countries']))
			$model->attributes=$_GET['Countries'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}
	
	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Countries the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Countries::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Countries $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='countries-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}

		
	}

	/**
	*State list
	*
	*/
	public function actionStates()
	{
		
	    
	    $data=States::model()->findAll('country_id=:parent_id', 
	    				array(':parent_id'=>(int) $_POST['country_id']));
	                  
	    $data=CHtml::listData($data,'id','name'); 
	    foreach($data as $value=>$name)
	    {
	        echo CHtml::tag('option',
	                   array('value'=>$value),CHtml::encode($name),true);
	    }
	}

	/**
	*City list
	*
	*/
	public function actionCities()
	{
		
	    
	    $data=Cities::model()->findAll('state_id=:parent_id', 
	    				array(':parent_id'=>(int) $_POST['state_id']));
	                  
	    $data=CHtml::listData($data,'id','name'); 
	    foreach($data as $value=>$name)
	    {
	        echo CHtml::tag('option',
	                   array('value'=>$value),CHtml::encode($name),true);
	    }
	}


		/*public function actions()
			{
			return array(
			'suggestZip'=>array(
			'class'=>'ext.actions.XSuggestAction',
			'modelName'=>'Zipcodes',
			'methodName'=>'zipcode',
			),
			);
		}*/
}
