<?php

class CustomernewInvoicesController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','detail','usageCharge','mrcCharge','otherCharge'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new CustomernewInvoices;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['CustomernewInvoices']))
		{
			$model->attributes=$_POST['CustomernewInvoices'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->customer_invoice_id));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['CustomernewInvoices']))
		{
			$model->attributes=$_POST['CustomernewInvoices'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->customer_invoice_id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
	
		
		if(Yii::app()->request->isAjaxRequest) {
		$this->renderPartial('index');
	}else {
		$this->render('index');
	}
	}
	public function actionDetail()
	{
		

		$userId = Yii::app()->user->id;
		$customer = User::model()->with('customer_invoice')->findByPk($userId); 
		//// usage charge ////
		$query = "SELECT c.customerid, cust.accountcode as customer,c.callee_no as dialed, sum(cost) as cost, count(*) as attempts, sum(duration) as duration ,round(ifnull(avg(duration),0),4) as acd from cdrs c left join customer cust on c.customerid=cust.customerid where c.belongs_to=0 and cust.customerid={$userId}";
			$command= Yii::app()->db->createCommand($query);

			$usagedata = $command->queryAll();
			$usage_charge = $usagedata[0]['cost']*$usagedata[0]['duration'];
		//// usage charge ////
		///echo "<pre>"; print_r( $customer['user']['monthlyfee'] ); echo "<pre />"; exit();
		$monthlyfee = $customer['monthlyfee'];
		$data["data"] = array();		
		$url = Yii::app()->getBaseUrl()."/invoice/".$userId."/";
		$html = '<div class="pull-right dropdown">
						<a class="btn btn-default btn-ms dropdown-toggle" id="dLabel" role="button" data-toggle="dropdown" data-target="#" href="javascript: void(0);">View Detailed Charges&nbsp;<span class="caret"></span></a>
						<ul class="dropdown-menu" role="menu" aria-labelledby="dLabel">
							<li><a href="#route-edit-model" data-toggle="modal" onclick="usage_charge()" >Usage Charges</a></li>
						<li><a href="#route-edit-model" data-toggle="modal" onclick="mrc_charge()" >MRC Charges</a></li>
						<li><a href="#route-edit-model" data-toggle="modal" onclick="other_charge()" >Other Charges</a></li>
						</ul>
					</div>';	
		foreach ($customer['customer_invoice'] as $detail) {
			$date = explode("-", $detail['start_date']);
			$billing_period = $date[0].$date[1];
			$file_path = $url.$detail['customer_invoice_file'];
			$file_name = "<a target='_blank' href='{$file_path}'>{$detail['customer_invoice_file']}</a>";
			$data["data"][] = array($file_name,$billing_period,$date[1],$usage_charge,$monthlyfee,0,0,0,$html);
		}

		echo json_encode($data);
	}

	function actionUsageCharge() {
		$html = '<div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title">Usage</h4>
                    </div>
                   <div class="modal-body" style="height:107px;">
                   <table class="table table-bordered table-striped">
					<tr>
						<th>Bill Period</th>
						<th>Service Type</th>
						<th>Quantity</th>
						<th>Rate</th>
						<th>Charge</th>
						<th>MSF</th>
						<th>MST</th>
					</tr>
					<tr>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>
					</table>
					</div>
					<div class="modal-footer">
						<button data-dismiss="modal" class="btn btn-default" type="button">Close</button>						
					</div>';
		echo $html;

	}

	function actionMrcCharge() {
		$html = '<div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title">MRC</h4>
                    </div>
                   <div class="modal-body" style="height:107px;">
                   <table class="table table-bordered table-striped">
					<tr>
						<th>Bill Period</th>
						<th>Service Type</th>
						<th>Quantity</th>
						<th>Rate</th>
						<th>Charge</th>
						<th>MSF</th>
						<th>MST</th>
					</tr>
					<tr>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>
					</table>
					</div>
					<div class="modal-footer">
						<button data-dismiss="modal" class="btn btn-default" type="button">Close</button>						
					</div>';
		echo $html;

	}
	function actionOtherCharge() {
		$html = '<div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title">Others</h4>
                    </div>
                   <div class="modal-body" style="height:107px;">
                   <table class="table table-bordered table-striped">
					<tr>
						<th>Bill Period</th>
						<th>Service Type</th>
						<th>Quantity</th>
						<th>Rate</th>
						<th>Charge</th>
						<th>MSF</th>
						<th>MST</th>
					</tr>
					<tr>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>
					</table>
					</div>
					<div class="modal-footer">
						<button data-dismiss="modal" class="btn btn-default" type="button">Close</button>						
					</div>';
		echo $html;

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new CustomernewInvoices('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['CustomernewInvoices']))
			$model->attributes=$_GET['CustomernewInvoices'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return CustomernewInvoices the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=CustomernewInvoices::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CustomernewInvoices $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='customernew-invoices-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
