<?php

class UsersController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array( // allow authenticated user to perform 'create' and 'update' actions --- @
			array('allow',  // allow all users to perform 'index' and 'view' actions ----------- *
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow all user to perform 'create' and 'update' actions
				'actions'=>array('paymentDetail','create','update','account','makePayment'),
				'users'=>array('*'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions ---------- admin
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}
	

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Users;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Users']))
		{
			$model->attributes=$_POST['Users'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Users']))
		{
			$model->attributes=$_POST['Users'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}
	/**
	 * Make payment
	 * Onclick of make update it will give the payment view in pop up.
	 * 
	 */
	public function actionMakePayment()
	{
		$userid=Yii::app()->user->getId();
		
		$model = new User;
		$model1= new CustomerCreditCard;
		require_once Yii::app()->basePath . '/extensions/CIM/util.php';
		
		$user_data = User::model()->find("customerid=$userid");
		$creditCardData = CimAccess::getCreditCardData($user_data->customer_profile_id,$user_data->customerPaymentProfileId);
		
		if ("Ok" == $creditCardData->messages->resultCode) {
			$cardData['firstname'] = $creditCardData->paymentProfile->billTo->firstName;
			$cardData['lastname'] = $creditCardData->paymentProfile->billTo->lastName;
			$cardData['cardnumber'] = $creditCardData->paymentProfile->payment->creditCard->cardNumber;
		}
		else {
			$creditCardData = null;
		}
		Yii::log(CVarDumper::DumpAsString($creditCardData),CLogger::LEVEL_WARNING,'$creditCardData');
		$credit_card_details=CustomerCreditCard::model()->find("customerid=$userid");
		$userdetails = User::model()->with('countrydata','statedata')->find("customerid=$userid");
		$countries = Countries::model()->findAll();
		if(!empty($userdetails->country)) {
			$states = State::model()->findAll("country_id=$userdetails->country");
		}else {
			$states = array();
		}
		$this->renderPartial('payment',array('userdetails'=>$userdetails,'credit_card_details'=>$cardData,'model'=>$model,'model1'=>$model1, 'countries' => $countries, 'states' => $states));
	
	}
	
	
	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Users');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Users('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Users']))
			$model->attributes=$_GET['Users'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Users the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Users::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}
	public function actionAccount()
	{ 
		$userid=Yii::app()->user->getId(); 
        //$model = User::model()->findByPk($userid);
       
		//Yii::log(CVarDumper::DumpAsString($userid),CLogger::LEVEL_WARNING,'userid');
		$model = new InmateUser();		
		$model1= new CustomerCreditCard;
		require_once Yii::app()->basePath . '/extensions/CIM/util.php';
        if (isset($_POST['InmateUser'])) { 
			
				$condition = 'customerid ='.$userid;
			    $data['contactnamefirst'] = $_POST['InmateUser']['contactnamefirst'];
			    $data['contactnamelast'] = $_POST['InmateUser']['contactnamelast'];
				$model->updateAll( $_POST['InmateUser'], $condition );
				//refer: http://harrybailey.com/2011/08/yii-updateall-example/
				//http://www.yiiframework.com/doc/guide/1.1/en/database.ar#updating-record
				//http://stackoverflow.com/questions/20746805/how-does-the-update-operation-work-in-yii
				Yii::app()->user->setFlash('sucess','Your account changed successfully.');				
			//}
        }
       // $credit_card_cust_details=CustomerCreditCard::model()->find("customerid=$userid");
       $user_data = InmateUser::model()->find("customerid=$userid"); 
        $creditCardData = CimAccess::getCreditCardData($user_data->customer_profile_id,$user_data->customerPaymentProfileId);
        $inmateuser = InmateUser::model()->find("customerid=$userid");
        Yii::log(CVarDumper::DumpAsString($inmateuser),CLogger::LEVEL_WARNING,'$$inmateuser');
       // echo '<pre>';
      //  print_r($creditCardData);exit;
        if ("Ok" == $creditCardData->messages->resultCode) {
        	$cardData['firstname'] = $creditCardData->paymentProfile->billTo->firstName;
        	$cardData['lastname'] = $creditCardData->paymentProfile->billTo->lastName;
        	$cardData['cardnumber'] = $creditCardData->paymentProfile->payment->creditCard->cardNumber;
        }		
       
		$credit_card_details=CustomerCreditCard::model()->find("customerid=$userid");
		Yii::log ( CVarDumper::DumpAsString ( $creditCardData ), CLogger::LEVEL_WARNING, 'user_cardData' );
		$userdetails = InmateUser::model()->with('countrydata','statedata')->find("customerid=$userid"); 
		$countries = Countries::model()->findAll();
		if(!empty($userdetails->country)) {
        $states = State::model()->findAll("country_id=$userdetails->country"); 
    	}else {
    		$states = array();
    	}
		if(Yii::app()->request->isAjaxRequest) {
		$this->renderPartial('account',array('userdetails'=>$userdetails,'credit_card_details'=>$cardData,'model'=>$model,'model1'=>$model1, 'countries' => $countries, 'states' => $states));
		}else {
			$this->render('account',array('userdetails'=>$userdetails,'credit_card_details'=>$cardData,'model'=>$model,'model1'=>$model1, 'countries' => $countries, 'states' => $states));
		}
		
	}

	public function actionPaymentDetail() {
		$userid = Yii::app()->user->getId(); 
		$datas = CustomerPayment::model()->findAll("payerid=$userid");
		
		if (!empty($datas)) {		
		
		foreach ($datas as $key => $value) {
			$customer_id = $value->customerid;
			$customer_model= User::model()->find("customerid=$customer_id");
			
			$data["data"][] = array($customer_model->inmatenumber,$value->amount,$value->paymentdatetime,$value->paymentmethod,$value->invoicenumber);
		}
	}else {
		$data["data"] = array();
	}

		echo json_encode($data);
	

		
	}

	/**
	 * Performs the AJAX validation.
	 * @param Users $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='users-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
