<?php

/**
 * This is the model class for table "customernew_invoices".
 *
 * The followings are the available columns in table 'customernew_invoices':
 * @property integer $customer_invoice_id
 * @property integer $customer_id
 * @property string $customer_invoice_file
 * @property string $start_date
 * @property string $end_date
 * @property string $update_date
 */
class CustomernewInvoices extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'customernew_invoices';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customer_id, customer_invoice_file, start_date, end_date, update_date', 'required'),
			array('customer_id', 'numerical', 'integerOnly'=>true),
			array('customer_invoice_file', 'length', 'max'=>200),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('customer_invoice_id, customer_id, customer_invoice_file, start_date, end_date, update_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			   'user'=>array(self::BELONGS_TO, 'User', 'customerid'),
			   'customer_number'=>array(self::BELONGS_TO, 'CustomerNumber', 'customer_number_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'customer_invoice_id' => 'Customer Invoice',
			'customer_id' => 'Customer',
			'customer_invoice_file' => 'Customer Invoice File',
			'start_date' => 'Start Date',
			'end_date' => 'End Date',
			'update_date' => 'Update Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('customer_invoice_id',$this->customer_invoice_id);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('customer_invoice_file',$this->customer_invoice_file,true);
		$criteria->compare('start_date',$this->start_date,true);
		$criteria->compare('end_date',$this->end_date,true);
		$criteria->compare('update_date',$this->update_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CustomernewInvoices the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
