<?php

/**
 * This is the model class for table "facility_numberpool".
 *
 * The followings are the available columns in table 'facility_numberpool':
 * @property string $pnumber
 * @property integer $location
 * @property integer $status
 * @property string $ratecenter
 * @property integer $vendorid
 */
class FacilityNumberpool extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'facility_numberpool';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('pnumber', 'required'),
			array('location, status, vendorid', 'numerical', 'integerOnly'=>true),
			array('pnumber, ratecenter', 'length', 'max'=>50),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('pnumber, location, status, ratecenter, vendorid', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'pnumber' => 'Pnumber',
			'location' => 'Location',
			'status' => 'Status',
			'ratecenter' => 'Ratecenter',
			'vendorid' => 'Vendorid',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('pnumber',$this->pnumber,true);
		$criteria->compare('location',$this->location);
		$criteria->compare('status',$this->status);
		$criteria->compare('ratecenter',$this->ratecenter,true);
		$criteria->compare('vendorid',$this->vendorid);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FacilityNumberpool the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
