
<?php
/* @var $this TollFreeNosController */
/* @var $model TollFreeNos */

$this->breadcrumbs=array(
	'Toll Free Noses'=>array('index'),
	'Manage',
);

$this->menu=array(
	array('label'=>'List TollFreeNos', 'url'=>array('index')),
	array('label'=>'Create TollFreeNos', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$('#toll-free-nos-grid').yiiGridView('update', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Toll Free Noses</h1>

<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'toll-free-nos-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'id',
		'prefix_id',
		'number',
		array(
			'class'=>'CButtonColumn',
		),
	),
)); ?>
