<?php
class Registration extends CActiveRecord
 { 
	public $firstname ; 
	public $lastname ; 
	public $address1; 
	public $country; 	
	public $city ; 
	public $state;
	public $zip;
	public $email;
	public $username;
	public $userpassword;
	public $password_repeat;	
	
	public function tableName() 
	{ 
		return 'customer'; 
	}
	
	public function rules() { 
		return array(array('firstname, lastname,address1,city,state,username,userpassword,password_repeat,email,country', 'required'),
		array('email', 'email','message'=>"The email isn't correct"),		
        array('username', 'uniqueUsername'), 
		array('password_repeat', 'compare', 'compareAttribute'=>'userpassword'),
		array('zip','numerical','integerOnly'=>true),
		array ( "address1, firstname" , "safe" ) 
		); 
	} 
	
	public function uniqueUsername($attribute, $params)
    {
        if($user = User::model()->exists('username=:username',array('username'=>$this->username)))
          $this->addError($attribute, 'username already exists!');
    }
	
	public function beforeSave() {
     if ($this->isNewRecord) // <---- the difference
         $this->userpassword=md5($this->userpassword);
     return true;
 	}
}
?>