<?php

class OrderController extends Controller
{
		public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array(),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('index','history','historyDetail','pdf'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array(),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actionIndex()
	{
		// inmate
		$data=FacilityLocation::model()->findAll();
		$list = CHtml::listData($data, 'id', 'facility');
		
		//tollfree
		$tollfreemodel = new TollFreeNoPrefix;

		//invoice
		$userid=Yii::app()->user->getId();
		$userdetails=Dashboard::model()->find("customerid=$userid");

		// minutes rate
		$adminServices = AdminServices::model()->findAll();	

		//payment
		
		$userid=Yii::app()->user->getId();
		$model1= new CustomerCreditCard;
		$model2 = new User;	
		//$credit_card_details=array();
		//$credit_card_details=CustomerCreditCard::model()->find("customerid=$userid");
		$user_data = User::model()->find("customerid=$userid"); 
		// check for first inmate number
		$criteria = new CDbCriteria;  
		$criteria->condition = 'type =:type AND customerId =:userid';
		$criteria->params=array(':type'=>'inmate', ':userid'=>$userid);
		$inmateData = CustomerNumber::model()->findAll($criteria);		
		if (empty($inmateData)) {
			$inmateStatus = 0;
		}else {
			$inmateStatus = 1;
		}
        $creditCardData = CimAccess::getCreditCardData($user_data->customer_profile_id,$user_data->customerPaymentProfileId);
        $cardData['firstname'] = '';
        $cardData['lastname'] = '';
        $cardData['cardnumber'] = '';

        if ("Ok" == $creditCardData->messages->resultCode) {
        	$cardData['firstname'] = $creditCardData->paymentProfile->billTo->firstName;
        	$cardData['lastname'] = $creditCardData->paymentProfile->billTo->lastName;
        	$cardData['cardnumber'] = $creditCardData->paymentProfile->payment->creditCard->cardNumber;
        }	


		if(Yii::app()->request->isAjaxRequest) {
		$this->renderPartial('order',array('list'=>$list,'tollfreemodel' => $tollfreemodel));
	}else {
		$this->render('order',array('list'=>$list,'tollfreemodel' => $tollfreemodel,'userdetails' => $userdetails,'adminServices' => $adminServices, 'credit_card_details' => $cardData, 'model2' => $model2, 'model1' => $model2, 'inmate_status' => $inmateStatus));
	}
	}
	public function actionHistory() {

		if(Yii::app()->request->isAjaxRequest) {
		$this->renderPartial('history');
	}else {
		$this->render('history');
	}

	}
	public function actionHistoryDetail() {
		$userid=Yii::app()->user->getId();
		$order_history = CustomernewInvoices::model()->with('customer_number')->findAll("customer_id=$userid");
		
		foreach ($order_history as $value) {
			switch ($value['customer_number']['ring_type']) {
				case 'us&ca':
					$ring_type = "US or Canada Number";
					break;
				case 'int':
					$ring_type = "International Number";
					break;
				default:
					$ring_type = "";
					break;
			}
			$status = '<span class="label label-success">Completed</span>';
			$data["data"][] = array($value->customer_invoice_id,$value['customer_number']['type'],$status,$value['customer_number']['localnumber'],$ring_type,$value['customer_number']['pwdnumber'],$value['customer_number']['localnumber'],date('m/d/Y', strtotime($value['customer_number']['starttime'])));
		}
		echo json_encode($data);
	}
	/**
	 * This is the action to handle external exceptions.
	 */
	public function actionError()
	{
		if($error=Yii::app()->errorHandler->error)
		{
			if(Yii::app()->request->isAjaxRequest)
				echo $error['message'];
			else
				$this->render('error', $error);
		}
	}
	public function actionPdf() {
			$userid=Yii::app()->user->getId();
			$cookie = Yii::app()->request->cookies['buy_number']->value; 
			$filePath = CimAccess::saveInvoicePdf($cookie['service_type'],$cookie['selected_number'],$cookie['ring_location'],$cookie['destination_number'],$cookie['prepaid_amount']);		

			$command->insert('customernew_invoices', array(
			    'customer_id'=> $userid,
			    'customer_invoice_file'=>$filePath,
			    'start_date' => date("Y-m-d"),
			    'end_date' => date("Y-m-d"),
			    'update_date' => date("Y-m-d")
			    ));
		$this->redirect(array('customerNumber/index'));
	}
public function actionHtml() {
	echo Yii::app()->getBaseUrl();
}
	public function actionFailure() { 
		$this->render("failure");
	}
	// Uncomment the following methods and override them if needed
	/*
	public function filters()
	{
		// return the filter configuration for this controller, e.g.:
		return array(
			'inlineFilterName',
			array(
				'class'=>'path.to.FilterClass',
				'propertyName'=>'propertyValue',
			),
		);
	}

	public function actions()
	{
		// return external action classes, e.g.:
		return array(
			'action1'=>'path.to.ActionClass',
			'action2'=>array(
				'class'=>'path.to.AnotherActionClass',
				'propertyName'=>'propertyValue',
			),
		);
	}
	*/
}