<?php 
class CimAccess {

	public static function getCreditCardData( $profileId, $paymentProfileId ) {
			require_once Yii::app()->basePath . '/extensions/CIM/util.php';
			$content = "<?xml version=\"1.0\" ?>".
		"<getCustomerPaymentProfileRequest xmlns=\"AnetApi/xml/v1/schema/AnetApiSchema.xsd\">".
			MerchantAuthenticationBlock().
		"<customerProfileId>".$profileId."</customerProfileId>".
		"<customerPaymentProfileId>".$paymentProfileId."</customerPaymentProfileId>".
		"</getCustomerPaymentProfileRequest>";
		//echo "Raw request: " . htmlspecialchars($content) . "<br><br>";
		$response = send_xml_request($content);
		//echo "Raw response: " . htmlspecialchars($response) . "<br><br>";
		$parsedresponse = parse_api_response($response); 
		return $parsedresponse;
	}

public static function saveCreditCard( $user_id, $user_email,$address, $city, $state, $zip, $cardNumber, $expiryDate, $cvv, $fname, $lname, $pno) {
	
 //echo $user_id."--".$user_email."--".$cardNumber."--".$expiryDate."--".$cvv."--".$fname."--".$lname."--".$pno;
	require_once Yii::app()->basePath . '/extensions/CIM/util.php';
	//create profile starts	
	$content1 =
	"<?xml version=\"1.0\" encoding=\"utf-8\"?>" .
	"<createCustomerProfileRequest xmlns=\"AnetApi/xml/v1/schema/AnetApiSchema.xsd\">" .
	MerchantAuthenticationBlock().
	"<profile>".
	"<merchantCustomerId>". $user_id."</merchantCustomerId>". // Your own identifier for the customer.
	"<description></description>".
	"<email>".$user_email."</email>".
	"</profile>".
	"</createCustomerProfileRequest>";
	
$response1 = send_xml_request($content1); 
$parsedresponse1 = parse_api_response($response1); 
	if ("Ok" == $parsedresponse1->messages->resultCode) {
		
		//echo $parsedresponse1->customerProfileId ."--".$parsedresponse1->messages->resultCode;
			$content2 = 
			"<?xml version=\"1.0\" encoding=\"utf-8\"?>" .
			"<createCustomerPaymentProfileRequest xmlns=\"AnetApi/xml/v1/schema/AnetApiSchema.xsd\">" .
			MerchantAuthenticationBlock().
			"<customerProfileId>" . $parsedresponse1->customerProfileId. "</customerProfileId>".
			"<paymentProfile>".
			"<customerType>business</customerType>".
			"<billTo>".
				"<firstName>".$fname."</firstName>".
				"<lastName>".$lname."</lastName>".
				"<address>".$address."</address>".
				"<city>".$city."</city>".
				"<state>".$state."</state>".
				"<zip>".$zip."</zip>".
				"<phoneNumber>".$pno."</phoneNumber>".				
			"</billTo>".
			"<payment>".
			 "<creditCard>".
			  "<cardNumber>".$cardNumber."</cardNumber>".
			  "<expirationDate>".$expiryDate."</expirationDate>". // required format for API is YYYY-MM
			 "</creditCard>".
			"</payment>".
			"</paymentProfile>".
			"<validationMode>liveMode</validationMode>". // or liveMode
			"</createCustomerPaymentProfileRequest>";
			
		$response2 = send_xml_request($content2);		
		$parsedresponse2 = parse_api_response($response2); 
		
		if ("Ok" == $parsedresponse2->messages->resultCode) {	
		
		//echo $parsedresponse2->customerPaymentProfileId ."--".$parsedresponse1->customerProfileId ;
				$content3 =
					"<?xml version=\"1.0\" encoding=\"utf-8\"?>" .
					"<createCustomerShippingAddressRequest xmlns=\"AnetApi/xml/v1/schema/AnetApiSchema.xsd\">" .
					MerchantAuthenticationBlock().
					"<customerProfileId>" . $parsedresponse1->customerProfileId . "</customerProfileId>".
					"<address>".
					"<firstName>".$fname."</firstName>".
					"<lastName>".$lname."</lastName>".					
					"<address>".$address."</address>".
					"<city>".$city."</city>".
					"<state>".$state."</state>".
					"<zip>".$zip."</zip>".
					"<phoneNumber>".$pno."</phoneNumber>".
					"</address>".
					"</createCustomerShippingAddressRequest>";					
					$response3 = send_xml_request($content3);
					$parsedresponse3 = parse_api_response($response3);
					if ("Ok" == $parsedresponse3->messages->resultCode) {
						//echo $parsedresponse3->customerAddressId;
							$cimResponse['shippingId']  = htmlspecialchars($parsedresponse3->customerAddressId);

							$cimResponse['paymentProfileId']  = htmlspecialchars($parsedresponse2->customerPaymentProfileId);
				
							$cimResponse['profileId']  = htmlspecialchars($parsedresponse1->customerProfileId);
							//print_r($cimResponse);
							return $cimResponse;
					}			
				
		}
	}else{
		Yii::app()->user->setFlash('warning', "Transaction is not successful_cimAccess 2)");
                            $this->redirect(array('search'));
	}
	
			

}

public static function updateCreditCard( $profileId, $paymentProfileId, $cardNumber, $expiryDate, $cvv, $fname, $lname) {
		require_once Yii::app()->basePath . '/extensions/CIM/util.php';
		$content = "<?xml version=\"1.0\" encoding=\"utf-8\"?>".
		"<updateCustomerPaymentProfileRequest xmlns=\"AnetApi/xml/v1/schema/AnetApiSchema.xsd\">".
			MerchantAuthenticationBlock().
		"<customerProfileId>".$profileId."</customerProfileId>".
		"<paymentProfile>".
		"<customerType>individual</customerType>". // individual or business -->
		"<billTo>".
			 "<firstName>".$fname."</firstName>".
			 "<lastName>".$lname."</lastName>".			 
		"</billTo>".
		"<payment>".
		"<creditCard>".
		"<cardNumber>".$cardNumber."</cardNumber>".
		"<expirationDate>".$expiryDate."</expirationDate>".
		"</creditCard>".
		"</payment>".
		"<customerPaymentProfileId>".$paymentProfileId."</customerPaymentProfileId>".
		"</paymentProfile>".
		"<validationMode>liveMode</validationMode>".
		"</updateCustomerPaymentProfileRequest>";		
		$response = send_xml_request($content);	
		$parsedresponse = parse_api_response($response); 
		if ("Ok" == $parsedresponse->messages->resultCode) {
			return true;
		}
}

public static function goForTransaction( $profileId, $paymentProfileId, $shippingId, $amount, $giatri_block, $so_block, $gia_block) {
	
	// echo $name_block ."--". $so_block ."--". $gia_block ."--". $amount;
	$invoice = strtotime(date("Y-m-d H:i:s"));
	$content =
	"<?xml version=\"1.0\" encoding=\"utf-8\"?>" .
	"<createCustomerProfileTransactionRequest xmlns=\"AnetApi/xml/v1/schema/AnetApiSchema.xsd\">" .
	MerchantAuthenticationBlock().
	"<transaction>".
	"<profileTransAuthCapture>".
	"<amount>" . $amount . "</amount>".
	// "<shipping>".
	// "<amount>0.00</amount>".
	// "<name>Free Shipping</name>".
	// "<description>Free UPS Ground shipping. Ships in 5-10 days.</description>".
	// "</shipping>".
	"<lineItems>".
	"<itemId>Minute</itemId>".
	"<name>Block of ".$giatri_block." minutes</name>".
	"<quantity>".$so_block."</quantity>".
	"<unitPrice>" . $gia_block . "</unitPrice>".
	//"<taxable>false</taxable>".
	"</lineItems>".
	
	"<customerProfileId>" . $profileId . "</customerProfileId>".
	"<customerPaymentProfileId>" . $paymentProfileId . "</customerPaymentProfileId>".
	"<customerShippingAddressId>" . $shippingId . "</customerShippingAddressId>".
	"<order>".
	"<invoiceNumber>".$invoice."</invoiceNumber>".
	"</order>".
	
	"</profileTransAuthCapture>".
	"</transaction>".
	"</createCustomerProfileTransactionRequest>"; 
	
	//////////////////////new add code create transaction
	// "<createTransactionRequest xmlns=\"AnetApi/xml/v1/schema/AnetApiSchema.xsd\">".
	// "MerchantAuthenticationBlock()".
  
  // "<transactionRequest>".
   // " <transactionType>authCaptureTransaction</transactionType>".
   // "<amount>" . $amount . "</amount>".
    // "<profile>".
      // "<customerProfileId>". $profileId ."</customerProfileId>".
      // "<paymentProfile>".
        // "<paymentProfileId>". $paymentProfileId ."</paymentProfileId>".
      // "</paymentProfile>".
    // "</profile>".
    // "<lineItems>".
      // "<lineItem>".
        // "<itemId>Minute</itemId>".
        // "<name>Block of ".$giatri_block." minutes</name>".
       // "<quantity>".$so_block."</quantity>".
	// "<unitPrice>" . $gia_block . "</unitPrice>".
      // "</lineItem>".
    // "</lineItems>".

   // " <order>".
      // "<invoiceNumber>".$invoice."</invoiceNumber>".
      
   // " </order>".
 // " </transactionRequest>".
// "</createTransactionRequest>".
	
	// echo"<pre>";
	// htmlspecialchars($content);
	// echo"</pre>";
$response = send_xml_request($content);
$parsedresponse = parse_api_response($response);

if ("Ok" == $parsedresponse->messages->resultCode) {
	
}
if (isset($parsedresponse->directResponse)) {
	
	$directResponseFields = explode(",", $parsedresponse->directResponse);
	$responseCode = $directResponseFields[0]; // 1 = Approved 2 = Declined 3 = Error
	$responseReasonCode = $directResponseFields[2]; // See http://www.authorize.net/support/AIM_guide.pdf
	$responseReasonText = $directResponseFields[3];
	$approvalCode = $directResponseFields[4]; // Authorization code
	$transId = $directResponseFields[6];
	$invoiceNumber = $directResponseFields[7];
	
	if ("1" == $responseCode) $msg = "success";
	else if ("2" == $responseCode) $msg = "failure";
	else  $msg = "failure";
	//die();
	/*echo "responseReasonCode = " . htmlspecialchars($responseReasonCode) . "<br>";
	echo "responseReasonText = " . htmlspecialchars($responseReasonText) . "<br>";
	echo "approvalCode = " . htmlspecialchars($approvalCode) . "<br>";*/
	$transId =  htmlspecialchars($transId);
	//echo $transId."----";
}else {
	 $msg = "failure";
}
$data['msg'] = $msg;
$data['transId'] = $transId;
$data['invoiceNumber'] = $invoiceNumber;
return $data;
}

public static function saveInvoicePdf($serviceType,$selected_number,$ring_location,$destination_number,$prepaid_amount) {
	require_once Yii::app()->basePath . '/extensions/tcpdf/tcpdf_include.php';
			$userid=Yii::app()->user->getId();
			$path =Yii::getPathOfAlias('webroot').'/invoice/'.$userid; 
if (!is_dir($path)) {
    mkdir($path, 0777, true);
}
// create new PDF document
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Invoice');
$pdf->SetTitle('Customer Invoice');
$pdf->SetSubject('Sample text');
$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
$pdf->setFooterData(array(0,64,0), array(0,64,128));

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
	require_once(dirname(__FILE__).'/lang/eng.php');
	$pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set default font subsetting mode
$pdf->setFontSubsetting(true);

// Set font
// dejavusans is a UTF-8 Unicode font, if you only need to
// print standard ASCII chars, you can use core fonts like
// helvetica or times to reduce file size.
$pdf->SetFont('dejavusans', '', 14, '', true);

// Add a page
// This method has several options, check the source code documentation for more information.
$pdf->AddPage();

// set text shadow effect
$pdf->setTextShadow(array('enabled'=>true, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));
$a1 = rand(5, 15);
$a2 = rand(5, 15);
$date = date("Y-m-d");

			switch ($serviceType) {
				case 'us&ca':
					$service_type = "US and Canada Number";
					break;
				case 'int':
					$service_type = "International Number";
					break;
				default:
					$service_type = "";
					break;
				}

$data = "
<!-- Invoice table -->
       ";
// Set some content to print
$html = <<<EOF
<style>#page-wrap { width: 800px; margin: 20px auto; border: 1px solid #000000;}
#inner-content {width: 95%; margin: 5px 5px 10px 20px;}
table { border-collapse: collapse; }
table td, table th { border: 1px solid black; padding: 5px; }
</style>
 <div id='page-wrap'>
        <div id='inner-content'>
        <div id='invoice-header'>INVOICE</div>        
        <div id='identity'>        
            <div id='address'>
            qw, <br/>
			Phone: 123</div>         
        </div>        
        <div style='clear:both'></div>        
        <div id='customer'>        
            <table id='meta'>
                <tr>
                    <td class='meta-head'>Customer #</td>
                    <td>$a1</td>
                </tr>
                <tr>
                    <td class='meta-head'>Invoice #</td>
                    <td>$a2</td>
                </tr>
                <tr>
                    <td class='meta-head'>Date</td>
                    <td>$date </td>
                </tr>
                <tr>
                    <td class='meta-head'>Amount</td>
                    <td>$prepaid_amount</td>
                </tr>
            </table>        
        </div>        
        <table id='items'>        
          <tr>
              <td class='title-color'>Service Type</td>
              <td class='item-name'>$service_type</td>
          </tr>
          <tr>
              <td class='title-color'>Number</td>
               <td class='description'>$selected_number</td>
          </tr>
          <tr>
              <td class='title-color'>Ring Location</td>
               <td>$ring_location</td>
          </tr>
          <tr>
              <td class='title-color'>Ring Number</td>
              <td>$destination_number</td>
          </tr>     
          <tr>
              <td class='title-color'>Amount</td>
              <td>$prepaid_amount</td>
          </tr>
          <tr>            
              <td colspan='1' class='total-line balance'>Total Amount</td>
              <td class='total-value balance'>$prepaid_amount</td>
          </tr>        
        </table>
        </div>        
    </div>
EOF;

// Print text using writeHTMLCell()
$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

// ---------------------------------------------------------
$fileName = strtotime(date("Y-m-d H:i:s")).".pdf";
// Close and output PDF document
// This method has several options, check the source code documentation for more information.
$pdf->Output($path."/".$fileName , 'F');
return $fileName;
}

public static function payAsGuest($cardNumber,$expiryDate,$cvv,$amount,$postData) {
	//require_once Yii::app()->basePath . '/extensions/CIM/AuthorizeNet.php';

				// API credentials only need to be defined once
			 /* define("AUTHORIZENET_API_LOGIN_ID", "4gT3Dk52");
			  define("AUTHORIZENET_TRANSACTION_KEY", "2Wpk95LsCY52v536");
			  define("AUTHORIZENET_SANDBOX", true);*/
			$post_url = "https://secure.authorize.net/gateway/transact.dll";

$post_values = array(
	
	// the API Login ID and Transaction Key must be replaced with valid values
	"x_login"			=> "68zYpJ42",
							
	"x_tran_key"		=> "5FAg8g23JwHB47cx",
						
	"x_version"			=> "3.1",
	"x_delim_data"		=> "TRUE",
	"x_delim_char"		=> "|",
	"x_relay_response"	=> "FALSE",

	"x_type"			=> "AUTH_CAPTURE",
	"x_method"			=> "CC",
	"x_card_num"		=> $cardNumber,
	"x_exp_date"		=> $expiryDate,

	"x_amount"			=> $amount,
	"x_invoice_num"     => strtotime(date("Y-m-d H:i:s")),
	"x_description"		=> "Inmate Payment",

	"x_first_name"		=> $postData['guestuser']['first_name'],
	"x_last_name"		=> $postData['guestuser']['last_name'],
	"x_address"			=> $postData['guestuser']['address'],
	"x_city"			=> $postData['guestuser']['city'],
	"x_state"			=> $postData['guestuser']['state'],
	"x_zip"				=> $postData['guestuser']['zip']
);

$post_string = "";
foreach( $post_values as $key => $value )
	{ $post_string .= "$key=" . urlencode( $value ) . "&"; }
$post_string = rtrim( $post_string, "& " );


$request = curl_init($post_url); // initiate curl object
	curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response
	curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)
	curl_setopt($request, CURLOPT_POSTFIELDS, $post_string); // use HTTP POST to send form data
	curl_setopt($request, CURLOPT_SSL_VERIFYPEER, FALSE); // uncomment this line if you get no gateway response.
	$post_response = curl_exec($request); // execute curl post and store results in $post_response
	curl_close ($request); // close curl object

$response_array = explode($post_values["x_delim_char"],$post_response);
if ($response_array[0] == 1) {
	$transactionData['transId'] = $response_array[6];
	$transactionData['invoiceNumber'] = $response_array[7];
	$transactionData['msg'] = "success";
	return $transactionData;
}else{
	$transactionData['msg'] = "failure";
	return $transactionData;
}

}

public static function send_purchase_confirmation($to, $subject, $message) {
	if(empty($message))
		return;

//	$email = Yii::app()->email;
	$to = $to;
	$subject = $subject;
	$file_path = dirname(__FILE__).'/invoice_email_template.txt';
	$fh = fopen($file_path, 'r');
	$theData = fread($fh, filesize($file_path));
	fclose($fh);
	$address = str_replace(",", ",<br />", $message['address']);
	$theData = str_replace("user_name", $message['name'], $theData);
	$theData = str_replace("inmate_name", $message['inmate_name'], $theData);
	$theData = str_replace("invoice_id", $address, $theData);
	$theData = str_replace("invoice_date", $message['date'], $theData);
	$theData = str_replace("inmate_no", $message['inmate_no'], $theData);
	
	$theData = str_replace("name_block","Blocks of Minutes ", $theData);
	$theData = str_replace("so_block", $message['so_block'], $theData);
	$theData = str_replace("gia_block", "$4.00", $theData);
	$theData = str_replace("amount", $message['amount'], $theData);

	$theData = str_replace("total_amt", $message['amount'], $theData);
	//$message = $theData;
     $headers = array (
						'Reply-To: register@ylcmail.com',
						'X-Mailer: PHP/5.0',
						'MIME-Version: 1.0',
						'Content-type: text/html; charset=iso-8859-1'
					);
	Yii::app()->email->send('register@ylcmail.com', $to, $subject, $theData,$headers);
	// require 'PhpEmail.php';
	// $mail = new PhpEmail();
	// $mail->send( $to, $subject, $message);


}
//////////////////////delete customer_profile, delete payment_profile/////////////////
public static function delete_customer_profile($profileId){
	$content=
	"<?xml version=\"1.0\" encoding=\"utf-8\"?>".
	"<deleteCustomerProfileRequest xmlns=\"AnetApi/xml/v1/schema/AnetApiSchema.xsd\">".
	"MerchantAuthenticationBlock()".
	"<customerProfileId>".$profileId."</customerProfileId>".
	"</deleteCustomerProfileRequest>";

		$response = $this->sendXMLRequest($content);	
		$parsedresponse = $this->parseAPIResponse($response);

		if ("Ok" == $parsedresponse->messages->resultCode) {
		
			return array("result"=>"success", "succmessage"=>"customerProfileId ".htmlspecialchars($customerProfileId)." was successfully deleted.");
		}
			
		return array("result"=>"error", "errmessage"=>htmlspecialchars($parsedresponse->messages->message->text));
}

public static function delete_payment_profile ($profileId, $paymentProfileId){
	$content=
	"<?xml version=\"1.0\" encoding=\"utf-8\"?>".
	"<deleteCustomerPaymentProfileRequest xmlns=\"AnetApi/xml/v1/schema/AnetApiSchema.xsd\">".
	"MerchantAuthenticationBlock()".
	"<customerProfileId>".$profileId."</customerProfileId>".
	"<customerPaymentProfileId>" . $paymentProfileId . "</customerPaymentProfileId>".
	"</deleteCustomerPaymentProfileRequest>";
	$response = $this->sendXMLRequest($content);	
		$parsedresponse = $this->parseAPIResponse($response);
		
		if ("Ok" == $parsedresponse->messages->resultCode) {
			return array("result"=>"success", "succmessage"=>"customerPaymentProfileId ".htmlspecialchars($customerPaymentProfileId)." was successfully deleted.");
			
		}
			
		return array("result"=>"error", "errmessage"=>htmlspecialchars($parsedresponse->messages->message->text));
}

}

?>