<?php
/**
 * Controller is the customized base controller class.
 * All controller classes for this application should extend from this base class.
 */
class Controller extends CController
{
	/**
	 * @var string the default layout for the controller view. Defaults to '//layouts/column1',
	 * meaning using a single column layout. See 'protected/views/layouts/column1.php'.
	 */
	public $layout='//layouts/column1';
	/**
	 * @var array context menu items. This property will be assigned to {@link CMenu::items}.
	 */
	public $menu=array();
	/**
	 * @var array the breadcrumbs of the current page. The value of this property will
	 * be assigned to {@link CBreadcrumbs::links}. Please refer to {@link CBreadcrumbs::links}
	 * for more details on how to specify this property.
	 */
	public $breadcrumbs=array();
	public function printLogs($log = 'empty logs',$data)
	{
		if ($this->restrictUrl ())
			Yii::log ( CVarDumper::DumpAsString ( $log ), CLogger::LEVEL_WARNING, $data );
	}
	
	public function restrictUrl(){
		$controller =  Yii::app()->controller->id;
		$action     =  Yii::app()->controller->action->id;
		if($action   == 'deleteAssets' || $action == 'showLogs'){
			return false;
		}
		return true;
	
	}
	public function sendJSONResponse($arr, $code = 200)
	{
		header('Content-type: application/json');
	
		$this->printLogs($arr,'<h2 style = "color:Green;"><b>Reponse</b></h2>');
		echo json_encode($arr);
		Yii::app()->end();
	}
}