<?php
class CustomerNumberController extends Controller {
	/**
	 *
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 *      using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	
	/**
	 *
	 * @return array action filters
	 */
	public function filters() {
		return array (
				'accessControl',
				
				// perform access control for CRUD operations
				'postOnly + delete' 
		)
		// we only allow deletion via POST request
		;
	}
	
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * 
	 * @return array access control rules
	 */
	public function accessRules() {
		return array (
				array (
						'allow',
						
						// allow all users to perform 'index' and 'view' actions
						'actions' => array (
								'quickPay',
								'clearInmateSession',
								'paymentByPaypal',
								'paymentExistingCard',
								'paymentNewCard',
								'confirmPayment',
								'selectBlocks',
								'getBop',
								'getBop2',
								'getBop3',
								'selectPayment',
								'checkUsername',
								'updatePassword',
								'paypalPayment',
								'payment',
								'payForInmate',
								'index',
								'view',
								'search' 
						),
						'users' => array (
								'*' 
						) 
				),
				array (
						'allow',
						
						// allow authenticated user to perform 'create' and 'update' actions
						'actions' => array (
								'updateNoteData',
								'getNoteData',
								'exportSelected',
								'statusChange',
								'create',
								'update',
								'detail',
								'getRouteData',
								'updateRouteData' 
						),
						'users' => array (
								'@' 
						) 
				),
				array (
						'allow',
						
						// allow admin user to perform 'admin' and 'delete' actions
						'actions' => array (
								'admin',
								'delete' 
						),
						'users' => array (
								'admin' 
						) 
				),
				array (
						'deny',
						
						// deny all users
						'users' => array (
								'*' 
						) 
				) 
		);
	}
	public function actionQuickPay() {
		$this->layout = "registration-layout";
		$this->render ( 'quick_pay' );
	}
	public function actionConfirmPayment() {
		$message = Yii::app ()->request->cookies ['confirm_payment']->value;
		if (empty ( $message ))
			$this->redirect ( array (
					'search' 
			) );
		
		$this->layout = "registration-layout";
		$file_path = dirname ( __FILE__ ) . '/../components/invoice_email_template.txt';
		$fh = fopen ( $file_path, 'r' );
		$theData = fread ( $fh, filesize ( $file_path ) );
		fclose ( $fh );
		
		unset ( Yii::app ()->request->cookies ['confirm_payment'] );
		unset ( Yii::app ()->request->cookies ['pay_for_inmate'] );
		Yii::app ()->request->cookies->clear ();
		
		$address = str_replace ( ",", ",<br />", $message ['address'] );
		$theData = str_replace ( "user_name", $message ['name'], $theData );
		$theData = str_replace ( "invoice_id", $address, $theData );
		$theData = str_replace ( "invoice_date", $message ['date'], $theData );
		$theData = str_replace ( "inmate_no", $message ['inmate_no'], $theData );
		$theData = str_replace ( "total_amt", $message ['amount'], $theData );
		$theData = str_replace ( "inmate_name", $message ['inmate_name'], $theData );
		
		$theData = str_replace ( "name_block", "Blocks of Minutes ", $theData );
		$theData = str_replace ( "so_block", $message ['so_block'], $theData );
		$theData = str_replace ( "gia_block", "$4.00", $theData );
		$theData = str_replace ( "amount", $message ['amount'], $theData );
		
		$this->render ( 'confirm_payment', array (
				'theData' => $theData 
		) );
	}
	// public function actionGetBop() {
	// $fname = $_POST['fname'];
	// $lname = $_POST['lname'];
	// $criteria = new CDbCriteria;
	// $criteria->condition = 'contactnamefirst=:fname AND contactnamelast=:lname';
	// $criteria->params = array(':fname' => $fname, ':lname' => $lname);
	// $data = User::model()->find($criteria);
	// if (!empty($data)) echo $data->inmatenumber;
	// else echo "";
	// }
	public function actionGetBop() {
		$fname = $_POST ['fname'];
		$criteria = new CDbCriteria ();
		$criteria->condition = 'contactnamefirst=:fname';
		$criteria->params = array (
				':fname' => $fname 
		);
		
		$data = User::model ()->find ( $criteria );
		if (! empty ( $data ))
			echo $data->inmatenumber;
		else
			echo "";
	}
	public function actionGetBop3() {
		$userid = Yii::app ()->user->getId ();
		if (isset ( $_POST ['fname'] ) && isset ( $_POST ['lname'] )) {
			$fname = $_POST ['fname'];
			$lname = $_POST ['lname'];
			$criteria = new CDbCriteria ();
			$criteria->condition = 'contactnamefirst=:fname AND contactnamelast=:lname';
			$criteria->params = array (
					':fname' => $fname,
					':lname' => $lname 
			);
			
			$data = User::model ()->find ( $criteria );
			if (! empty ( $data ))
				echo $data->inmatenumber;
			else
				echo "";
		}
	}
	public function actionGetBop2() {
		$userid = Yii::app ()->user->getId ();
		$fname = $_POST ['fname'];
		
		$criteria = new CDbCriteria ();
		// $criteria->condition = 'contactnamefirst=:fname AND customerid=:cusid';
		// $criteria->params = array(':fname' => $fname,':cusid' => $userid);
		$criteria->condition = 'contactnamefirst=:fname';
		$criteria->params = array (
				':fname' => $fname 
		);
		$data = User::model ()->find ( $criteria );
		if (! empty ( $data ))
			echo $data->contactnamelast;
		else
			echo "";
	}
	public function actionCheckUsername() {
		$username = $_POST ['username'];
		$criteria = new CDbCriteria ();
		$criteria->condition = 'username=:username';
		$criteria->params = array (
				':username' => $username 
		);
		$data = InmateUser::model ()->find ( $criteria );
		if (! empty ( $data ))
			echo "true";
		else
			echo "false";
	}
	public function actionUpdatePassword() {
		$u = $_POST ['username'];
		$email = $_POST ['email'];
		$p = md5 ( $_POST ['password'] );
		
		$command = Yii::app ()->db->createCommand ();
		$command->update ( 'inmate_customers', array (
				'userpassword' => $p 
		), 'username=:u', array (
				':u' => $u 
		), 'email=:e', array (
				':e' => $email 
		) );
		
		echo "true";
	}
	
	/*
	 * public function actionPayment() {
	 * $this->layout = "registration-layout";
	 * if (!empty($_POST)) {
	 * $payment_data = unserialize($_POST['payment_details']);
	 * $amount = str_replace("$", "", $_POST['price']);
	 * $loggeduserid = $payment_data['userid'];
	 * $inmateid = $payment_data['inmateid'];
	 * Yii::app()->request->cookies['pay_for_inmate[user_type]'] = new CHttpCookie('pay_for_inmate[user_type]', $payment_data['user_type']);
	 * Yii::app()->request->cookies['pay_for_inmate[userid]'] = new CHttpCookie('pay_for_inmate[userid]', $payment_data['userid']);
	 * Yii::app()->request->cookies['pay_for_inmate[amount]'] = new CHttpCookie('pay_for_inmate[amount]', $amount);
	 * Yii::app()->request->cookies['pay_for_inmate[inmateid]'] = new CHttpCookie('pay_for_inmate[inmateid]', $payment_data['inmateid']);
	 * if ($payment_data['user_type'] == "guest_user") {
	 * Yii::app()->request->cookies['pay_for_inmate[email_id]'] = new CHttpCookie('pay_for_inmate[email_id]', $_POST['guestuser']['email']);
	 * Yii::app()->request->cookies['pay_for_inmate[to_name]'] = new CHttpCookie('pay_for_inmate[to_name]', $_POST['guestuser']['first_name'] . " " . $_POST['guestuser']['last_name']);
	 * }
	 * if ($_POST['payment_type'] == "paypal") {
	 *
	 * define('SSL_URL', 'https://www.paypal.com/cgi-bin/webscr');
	 * define('SSL_SAND_URL', 'https://www.sandbox.paypal.com/cgi-bin/webscr');
	 * $data = array('merchant_email' => 'lmsmerchant@gmail.com', 'product_name' => 'Demo Product', 'amount' => $amount, 'currency_code' => 'USD', 'thanks_page' => "http://" . $_SERVER['HTTP_HOST'] . Yii::app()->createUrl("customerNumber/paypalPayment"), 'notify_url' => "http://" . $_SERVER['HTTP_HOST'] . Yii::app()->createUrl("customerNumber/paypalPayment"), 'cancel_url' => "http://" . $_SERVER['HTTP_HOST'] . Yii::app()->createUrl("/"), 'paypal_mode' => true,);
	 *
	 * $action = '';
	 *
	 * //Is this a test transaction?
	 * $action = SSL_SAND_URL;
	 *
	 * $form = '';
	 *
	 * $form.= '<form name="frm_payment_method" action="' . $action . '" method="post">';
	 * $form.= '<input type="hidden" name="business" value="' . $data['merchant_email'] . '" />';
	 *
	 * // Instant Payment Notification & Return Page Details /
	 * $form.= '<input type="hidden" name="notify_url" value="' . $data['notify_url'] . '" />';
	 * $form.= '<input type="hidden" name="cancel_return" value="' . $data['cancel_url'] . '" />';
	 * $form.= '<input type="hidden" name="return" value="' . $data['thanks_page'] . '" />';
	 * $form.= '<input type="hidden" name="rm" value="2" />';
	 *
	 * // Configures Basic Checkout Fields -->
	 * $form.= '<input type="hidden" name="lc" value="" />';
	 * $form.= '<input type="hidden" name="no_shipping" value="1" />';
	 * $form.= '<input type="hidden" name="no_note" value="1" />';
	 *
	 * // <input type="hidden" name="custom" value="localhost" />-->
	 * $form.= '<input type="hidden" name="currency_code" value="' . $data['currency_code'] . '" />';
	 * $form.= '<input type="hidden" name="page_style" value="paypal" />';
	 * $form.= '<input type="hidden" name="charset" value="utf-8" />';
	 * $form.= '<input type="hidden" name="item_name" value="' . $data['product_name'] . '" />';
	 * $form.= '<input type="hidden" value="_xclick" name="cmd"/>';
	 * $form.= '<input type="hidden" name="amount" value="' . $amount . '" />';
	 * $form.= '<script>';
	 * $form.= 'setTimeout("document.frm_payment_method.submit()", 2);';
	 * $form.= '</script>';
	 * $form.= '</form>';
	 *
	 * //die("hehe");
	 * $this->render('payByPaypal', array('form' => $form));
	 * }
	 * require_once Yii::app()->basePath . '/extensions/CIM/util.php';
	 * if ($payment_data['user_type'] == "app_user") {
	 * if ($_POST['payment_type'] == "existing_credit_card") {
	 * $user_data = InmateUser::model()->find("customerid=$loggeduserid");
	 * $transactionData = CimAccess::goForTransaction($user_data->customer_profile_id, $user_data->customerPaymentProfileId, $user_data->customerAddressId, $amount);
	 * if ($transactionData['msg'] == "failure") {
	 *
	 * Yii::app()->user->setFlash('warning', "Transaction is not successful");
	 * $this->redirect(array('search'));
	 *
	 * }
	 * }
	 * if ($_POST['payment_type'] == "new_credit_card") {
	 * if (!empty($_POST['guestuser']['email'])) {
	 *
	 * $command = Yii::app()->db->createCommand();
	 * $command->update('inmate_customers', array(
	 * 'contactnamefirst' => $_POST['guestuser']['first_name'],
	 * 'contactnamelast' => $_POST['guestuser']['last_name'],
	 * 'email' => $_POST['guestuser']['email'],
	 * 'address'=>$address = $_POST['guestuser']['address'].",".$_POST['guestuser']['city'].",".$_POST['guestuser']['state'],
	 * ), 'customerid=:id', array(':id'=>$loggeduserid));
	 *
	 * }
	 * $user_data = InmateUser::model()->find("customerid=$loggeduserid");
	 * $name = explode(" ", $_POST["CustomerCreditCard"]['name_card']);
	 * $fname = $lname = '';
	 * if (isset($name[0])) $fname = $name[0];
	 *
	 * if (isset($name[1])) $lname = $name[1];
	 *
	 * $cardtype = $_POST["CustomerCreditCard"]["cardtype"];
	 *
	 * $cardNO = $_POST["CustomerCreditCard"]['cardnumber'];
	 *
	 * // $expiryDate = $_POST["expiry_year"]."-".$_POST["expiry_month"];
	 * $expiryDate = $_POST["expiry_month"] . substr($_POST["expiry_year"], -2);
	 * $cvv = $_POST["CustomerCreditCard"]['csv'];
	 * if (empty($user_data->customer_profile_id) && empty($user_data->customerPaymentProfileId)) {
	 *
	 * // save credit card data.
	 * //$user_email = $user_data->email;
	 * $user_email = "t1@g1.com";
	 * $pno = '';
	 * if (empty($user_data->email)) {
	 * $address = $_POST['guestuser']['address'].",".$_POST['guestuser']['city'].",".$_POST['guestuser']['state'];
	 * }else {
	 * $address = $user_data->address;;
	 * }
	 * $creditCardData = CimAccess::saveCreditCard($loggeduserid, $user_email, $cardNO, $expiryDate, $cvv, $fname, $lname, $pno);
	 *
	 * if (!empty($creditCardData)) {
	 * $command = Yii::app()->db->createCommand();
	 * $command->update('inmate_customers', array('customer_profile_id' => $creditCardData['profileId'], 'customerPaymentProfileId' => $creditCardData['paymentProfileId'], 'customerAddressId' => $creditCardData['shippingId']), 'customerid=:id', array(':id' => $loggeduserid));
	 * $transactionData = CimAccess::goForTransaction($creditCardData['profileId'], $creditCardData['paymentProfileId'], $creditCardData['shippingId'], $amount);
	 *
	 * if ($transactionData['msg'] == "failure") {
	 * Yii::app()->user->setFlash('warning', "Transaction is not successful");
	 * $this->redirect(array('search'));
	 * }
	 * }
	 * print_r($transactionData);die("qwertyy");
	 * } else {
	 * $creditCardData = CimAccess::updateCreditCard($user_data->customer_profile_id, $user_data->customerPaymentProfileId, $cardNO, $expiryDate, $cvv, $fname, $lname);
	 *
	 * $transactionData = CimAccess::goForTransaction($user_data->customer_profile_id, $user_data->customerPaymentProfileId, $user_data->customerAddressId, $amount);
	 *
	 * if ($transactionData['msg'] == "failure") {
	 * Yii::app()->user->setFlash('warning', "Transaction is not successful");
	 * $this->redirect(array('search'));
	 * }
	 * }
	 * }
	 * } elseif ($payment_data['user_type'] == "guest_user") {
	 * $cardtype = $_POST["CustomerCreditCard"]["cardtype"];
	 *
	 * $cardNO = $_POST["CustomerCreditCard"]['cardnumber'];
	 * $expiryDate = $_POST["expiry_month"] . substr($_POST["expiry_year"], -2);
	 *
	 * //$expiryDate = "2016-02";
	 * $cvv = $_POST["CustomerCreditCard"]['csv'];
	 * $transactionData = CimAccess::payAsGuest($cardNO, $expiryDate, $cvv, $amount,$_POST);
	 * if ($transactionData['msg'] == "failure") {
	 * Yii::app()->user->setFlash('warning', "Transaction is not successful");
	 * $this->redirect(array('search'));
	 * }
	 * $to_email = $_POST['guestuser']['email'];
	 * $to_name = $_POST['guestuser']['first_name'] . " " . $_POST['guestuser']['last_name'];
	 * $fname = $_POST['guestuser']['first_name'];
	 * $lname = $_POST['guestuser']['last_name'];
	 * $email = $_POST['guestuser']['email'];
	 * }
	 * $user_data = array();
	 * $user_data = User::model()->find("customerid=$inmateid");
	 * $loggedinuserid = Yii::app()->user->getId();
	 *
	 * $loggedin_data = InmateUser::model()->find("customerid=$loggedinuserid");print_r( $loggedin_data); die();
	 * //inmate user follow
	 * $userid = $user_data->customerid;
	 * $newprepaidamount = $user_data->prepaidamount + $amount;
	 * $command = Yii::app()->db->createCommand();
	 * $command->update('customer', array('prepaidamount' => $newprepaidamount,), 'customerid=:id', array(':id' => $userid));
	 *
	 * if (empty($to_email)) $to_email = $user_data->email;
	 *
	 * if (empty($to_name)) {
	 *
	 * $to_name = $loggedin_data->contactnamefirst . " " . $loggedin_data->contactnamelast;
	 * $fname = $loggedin_data->contactnamefirst;
	 * $lname = $loggedin_data->contactnamelast;
	 * $email = $loggedin_data->email;
	 * }
	 * // if (Yii::app()->user->id) {
	 * $datetime = date("Y-m-d H:i:s");
	 * $command = Yii::app()->db->createCommand();
	 * //$command->insert('customer_payment', array('customerid' => $loggedinuserid, 'amount' => $amount, 'paymentdatetime' => $datetime, 'paymentmethod' => "Credit Card", 'invoicenumber' => $transactionData['transId']));
	 * if(!empty($transactionData)) {
	 * $command->insert('inmate_payments', array('inmate_id'=>$inmateid,'amount' => $amount, 'datetime' => $datetime, 'paymentmethod' => "Credit Card", 'transaction_id' => $transactionData['transId'],'firstname' => $fname, 'lastname' => $lname,'email'=>$email));
	 * }
	 * // }
	 * $inmate_name = $user_data->contactnamefirst . " " . $user_data->contactnamelast;
	 * $message = array('inmate_no' => $user_data->inmatenumber, 'amount' => $amount, 'name' => $to_name, 'date' => date("F j, Y"), 'inmate_name' => $inmate_name);
	 * $subject = "Inmate Invoice";
	 * CimAccess::send_purchase_confirmation($to_email, $subject, $message);
	 * Yii::app()->request->cookies['confirm_payment[inmate_no]'] = new CHttpCookie('confirm_payment[inmate_no]', $user_data->inmatenumber);
	 * Yii::app()->request->cookies['confirm_payment[amount]'] = new CHttpCookie('confirm_payment[amount]', $amount);
	 * Yii::app()->request->cookies['confirm_payment[name]'] = new CHttpCookie('confirm_payment[name]', $to_name);
	 * Yii::app()->request->cookies['confirm_payment[date]'] = new CHttpCookie('confirm_payment[date]', date("F j, Y"));
	 * Yii::app()->request->cookies['confirm_payment[inmate_name]'] = new CHttpCookie('confirm_payment[inmate_name]', $inmate_name);
	 * Yii::app()->user->setFlash('success', "Transaction successful");
	 * $this->redirect(array('confirmPayment'));
	 * }
	 * }
	 */
	public function actionPaymentExistingCard() {
		if (empty ( $_POST )) {
			Yii::app ()->user->setFlash ( 'warning', "Something went wrong" );
			$this->redirect ( array (
					'search' 
			) );
		}
		require_once Yii::app ()->basePath . '/extensions/CIM/util.php';
		$this->layout = "registration-layout";
		$payment_data = unserialize ( $_POST ['payment_details'] );
		$amount = str_replace ( "$", "", $_POST ['price'] );
		$payment_data ['so_block'] = $_POST ['so_block'];
		$so_block = $_POST ['so_block'];
		$gia_block = "4.00";
		$giatri_block = $_POST ['value_block'];
		$loggeduserid = $payment_data ['userid'];
		$inmateid = $payment_data ['inmateid'];
		Yii::app ()->request->cookies ['pay_for_inmate[user_type]'] = new CHttpCookie ( 'pay_for_inmate[user_type]', $payment_data ['user_type'] );
		Yii::app ()->request->cookies ['pay_for_inmate[userid]'] = new CHttpCookie ( 'pay_for_inmate[userid]', $payment_data ['userid'] );
		Yii::app ()->request->cookies ['pay_for_inmate[amount]'] = new CHttpCookie ( 'pay_for_inmate[amount]', $amount );
		Yii::app ()->request->cookies ['pay_for_inmate[inmateid]'] = new CHttpCookie ( 'pay_for_inmate[inmateid]', $payment_data ['inmateid'] );
		if ($payment_data ['user_type'] == "guest_user") {
			Yii::app ()->request->cookies ['pay_for_inmate[email_id]'] = new CHttpCookie ( 'pay_for_inmate[email_id]', $_POST ['guestuser'] ['email'] );
			Yii::app ()->request->cookies ['pay_for_inmate[to_name]'] = new CHttpCookie ( 'pay_for_inmate[to_name]', $_POST ['guestuser'] ['first_name'] . " " . $_POST ['guestuser'] ['last_name'] );
		}
		//
		if ($payment_data ['user_type'] == "app_user") {
			if ($_POST ['payment_type'] == "existing_credit_card") {
				$user_data = InmateUser::model ()->find ( "customerid=$loggeduserid" );
				$transactionData = CimAccess::goForTransaction ( $user_data->customer_profile_id, $user_data->customerPaymentProfileId, $user_data->customerAddressId, $amount, $giatri_block, $so_block, $gia_block );
				if ($transactionData ['msg'] == "failure") {
					Yii::app ()->user->setFlash ( 'warning', "Transaction is not successful" );
					$this->redirect ( array (
							'search' 
					) );
				}
			}
		}
		$transactionData ['transType'] = "Credit Card";
		$this->saveTransaction ( $payment_data, $transactionData );
	}
	public function actionpaymentByPaypal() {
		if (empty ( $_POST )) {
			Yii::app ()->user->setFlash ( 'warning', "Something went wrong" );
			$this->redirect ( array (
					'search' 
			) );
		}
		$this->layout = "registration-layout";
		$payment_data = unserialize ( $_POST ['payment_details'] );
		$amount = str_replace ( "$", "", $_POST ['price'] );
		$loggeduserid = $payment_data ['userid'];
		$inmateid = $payment_data ['inmateid'];
		
		$invoice = strtotime ( date ( "Y-m-d H:i:s" ) );
		Yii::app ()->request->cookies ['pay_for_inmate[block2]'] = new CHttpCookie ( 'pay_for_inmate[block2]', $payment_data['block2'] );
		Yii::app ()->request->cookies ['pay_for_inmate[user_type]'] = new CHttpCookie ( 'pay_for_inmate[user_type]', $payment_data ['user_type'] );
		Yii::app ()->request->cookies ['pay_for_inmate[userid]'] = new CHttpCookie ( 'pay_for_inmate[userid]', $payment_data ['userid'] );
		Yii::app ()->request->cookies ['pay_for_inmate[amount]'] = new CHttpCookie ( 'pay_for_inmate[amount]', $amount );
		Yii::app ()->request->cookies ['pay_for_inmate[inmateid]'] = new CHttpCookie ( 'pay_for_inmate[inmateid]', $payment_data ['inmateid'] );
		Yii::app ()->request->cookies ['pay_for_inmate[invoice]'] = new CHttpCookie ( 'pay_for_inmate[invoice]', $invoice );
		// new add....................
		if ($payment_data ['user_type'] == "guest_user") {
		$state = State::model()->findByPk($_POST ['guestuser'] ['state']);
		$address = $_POST ['guestuser'] ['address'];
		Yii::app ()->request->cookies ['pay_for_inmate[address]'] = new CHttpCookie ( 'pay_for_inmate[address]', $address );
		}
		else{
				$userid=Yii::app()->user->getId(); 
				$user_data = InmateUser::model()->find("customerid=$userid");
			if($user_data != null){
				
			$state = State::model()->findByPk($user_data->state);
			$address = $user_data->address . "," . $user_data->city . "," .$state->state_name . "," . $user_data->zip;
			Yii::app ()->request->cookies ['pay_for_inmate[address]'] = new CHttpCookie ( 'pay_for_inmate[address]', $address );
			}
		}
		if ($payment_data ['user_type'] == "guest_user") {
			Yii::app ()->request->cookies ['pay_for_inmate[email_id]'] = new CHttpCookie ( 'pay_for_inmate[email_id]', $_POST ['guestuser'] ['email'] );
			Yii::app ()->request->cookies ['pay_for_inmate[to_name]'] = new CHttpCookie ( 'pay_for_inmate[to_name]', $_POST ['guestuser'] ['first_name'] . " " . $_POST ['guestuser'] ['last_name'] );
			Yii::app ()->request->cookies ['pay_for_inmate[first_name]'] = new CHttpCookie ( 'pay_for_inmate[first_name]', $_POST ['guestuser'] ['first_name'] );
			Yii::app ()->request->cookies ['pay_for_inmate[last_name]'] = new CHttpCookie ( 'pay_for_inmate[last_name]', $_POST ['guestuser'] ['last_name'] );
			$address = $_POST ['guestuser'] ['address'];
			Yii::app ()->request->cookies ['confirm_payment[address]'] = new CHttpCookie ( 'confirm_payment[address]', $address );
		}else {
			$userid=Yii::app()->user->getId();
			$user_data = InmateUser::model()->find("customerid=$userid");
			if($user_data != null){
			Yii::app ()->request->cookies ['pay_for_inmate[email_id]'] = new CHttpCookie ( 'pay_for_inmate[email_id]', $user_data->email);
			Yii::app ()->request->cookies ['pay_for_inmate[to_name]'] = new CHttpCookie ( 'pay_for_inmate[to_name]', $user_data->contactnamefirst . " " . $user_data->contactnamelast );
			Yii::app ()->request->cookies ['pay_for_inmate[first_name]'] = new CHttpCookie ( 'pay_for_inmate[first_name]', $user_data->contactnamefirst );
			Yii::app ()->request->cookies ['pay_for_inmate[last_name]'] = new CHttpCookie ( 'pay_for_inmate[last_name]', $user_data->contactnamelast );
			$address = $user_data->address . "," . $user_data->city . "," . $state->state_name . "," . $user_data->zip;
			Yii::app ()->request->cookies ['confirm_payment[address]'] = new CHttpCookie ( 'confirm_payment[address]', $address );
		}
		}
		//
		if ($_POST ['payment_type'] == "paypal") {
			
			define ( 'SSL_URL', 'https://www.paypal.com/cgi-bin/webscr' );
			define ( 'SSL_SAND_URL', 'https://www.sandbox.paypal.com/cgi-bin/webscr' );
			// $data = array('merchant_email' => 'lmsmerchant@gmail.com', 'product_name' => 'Demo Product', 'amount' => $amount, 'currency_code' => 'USD', 'thanks_page' => "http://" . $_SERVER['HTTP_HOST'] . Yii::app()->createUrl("customerNumber/paypalPayment"), 'notify_url' => "http://" . $_SERVER['HTTP_HOST'] . Yii::app()->createUrl("customerNumber/paypalPayment"), 'cancel_url' => "http://" . $_SERVER['HTTP_HOST'] . Yii::app()->createUrl("/"), 'paypal_mode' => true,);
			$data = array (
					'merchant_email' => 'ricky.keele@digitalipvoice.com',
					'product_name' => 'Demo Product',
					'amount' => $amount,
					'currency_code' => 'USD',
					'thanks_page' => "http://" . $_SERVER ['HTTP_HOST'] . Yii::app ()->createUrl ( "customerNumber/paypalPayment" ),
					'notify_url' => "http://" . $_SERVER ['HTTP_HOST'] . Yii::app ()->createUrl ( "customerNumber/paypalPayment" ),
					'cancel_url' => "http://" . $_SERVER ['HTTP_HOST'] . Yii::app ()->createUrl ( "/" ),
					'paypal_mode' => true 
			);
			
			$action = '';
			
			// Is this a test transaction?
			$action = SSL_URL;
			
			$form = '';
			
			$form .= '<form name="frm_payment_method" action="' . $action . '" method="post">';
			$form .= '<input type="hidden" name="business" value="' . $data ['merchant_email'] . '" />';
			
			// Instant Payment Notification & Return Page Details /
			$form .= '<input type="hidden" name="notify_url" value="' . $data ['notify_url'] . '" />';
			$form .= '<input type="hidden" name="cancel_return" value="' . $data ['cancel_url'] . '" />';
			$form .= '<input type="hidden" name="return" value="' . $data ['thanks_page'] . '" />';
			$form .= '<input type="hidden" name="rm" value="2" />';
			
			// Configures Basic Checkout Fields -->
			$form .= '<input type="hidden" name="lc" value="" />';
			$form .= '<input type="hidden" name="no_shipping" value="1" />';
			$form .= '<input type="hidden" name="no_note" value="1" />';
			
			// <input type="hidden" name="custom" value="localhost" />-->
			$form .= '<input type="hidden" name="currency_code" value="' . $data ['currency_code'] . '" />';
			$form .= '<input type="hidden" name="page_style" value="paypal" />';
			$form .= '<input type="hidden" name="charset" value="utf-8" />';
			$form .= '<input type="hidden" name="item_name" value="' . $data ['product_name'] . '" />';
			$form .= '<input type="hidden" value="_xclick" name="cmd"/>';
			$form .= '<input type="hidden" name="amount" value="' . $amount . '" />';
			$form .= '<input type="hidden" name="invoice" value="' . $invoice . '" />';
			$form .= '<script>';
			$form .= 'setTimeout("document.frm_payment_method.submit()", 2);';
			$form .= '</script>';
			$form .= '</form>';
			
			// die("hehe");
			$this->render ( 'payByPaypal', array (
					'form' => $form 
			) );
		}
	}
	public function actionPaypalPayment() {
		// echo "qwert";die()
	
		 if ($_REQUEST ['payment_status'] != "Completed") {
			Yii::app ()->user->setFlash ( 'warning', "Transaction is not successful" );
			$this->redirect ( array (
					'search' 
			) );
		} 
		
		$cookie_data = Yii::app ()->request->cookies ['pay_for_inmate'];
		$inmateid = $cookie_data->value ['inmateid'];
		$payment_data ['so_block'] = $cookie_data->value ['block2'];
		$payment_data ['address'] = $cookie_data->value ['address'];
		// echo $payment_data['address']."----";
		// exit();
		$payment_data ['amount'] = $_REQUEST ['mc_gross'];
		$payment_data ['user_type'] = $cookie_data->value ['user_type'];
		$payment_data ['inmateid'] = $cookie_data->value ['inmateid'];
		
		$transactionData ['invoiceNumber'] = $cookie_data->value ['invoice'];
		$transactionData ['transId'] = $_REQUEST ['txn_id'];
		$transactionData ['transType'] = 'Paypal';
		$inmate_data = User::model ()->find ( "customerid=$inmateid" );
		if ($cookie_data->value ['user_type'] == "guest_user") {
			$data ['to_email'] = $cookie_data->value ['email_id'];
			$data ['to_name'] = $cookie_data->value ['to_name'];
			$data ['fname'] = $cookie_data->value ['first_name'];
			$data ['lname'] = $cookie_data->value ['last_name'];
		} else
			$data = array ();
		$this->saveTransaction ( $payment_data, $transactionData, $data );
		/*
		 * else {
		 * $userid = Yii::app()->user->getId();
		 * $user_data = User::model()->find("customerid=$userid");
		 * $to_email = $user_data->email;
		 * $to_name = $user_data->contactnamefirst . " " . $user_data->contactnamelast;
		 * }
		 * $inamte_name = $inmate_data->contactnamefirst . " " . $inmate_data->contactnamelast;
		 * $subject = "Inmate Invoice";
		 * $message = array('inmate_no' => $user_data->inmatenumber, 'amount' => $_REQUEST['mc_gross'], 'name' => $to_name, 'date' => date("F j, Y"), 'inmate_name' => $inmate_name);
		 *
		 * $newprepaidamount = $user_data->prepaidamount + $_REQUEST['mc_gross'];
		 * $command = Yii::app()->db->createCommand();
		 * $command->update('customer', array('prepaidamount' => $newprepaidamount,), 'customerid=:id', array(':id' => $userid));
		 * if (Yii::app()->user->id) {
		 * $command->insert('customer_payment', array('customerid' => $loggedinuserid, 'amount' => $amount, 'paymentdatetime' => $datetime, 'paymentmethod' => "Credit Card", 'invoicenumber' => $transactionData['transId']));
		 * }
		 * if(Yii::app()->user->id) {
		 * $datetime = date("Y-m-d H:i:s");
		 * $command = Yii::app()->db->createCommand();
		 * $command->insert('customer_payment', array(
		 * 'customerid'=>$userid,
		 * 'amount'=>$_REQUEST['mc_gross'],
		 * 'paymentdatetime' => $datetime,
		 * 'paymentmethod' => "Paypal",
		 * 'invoicenumber' => $_REQUEST['txn_id']
		 * ));
		 * }
		 * CimAccess::send_purchase_confirmation($to_email, $subject, $message);
		 * Yii::app()->request->cookies['confirm_payment[inmate_no]'] = new CHttpCookie('confirm_payment[inmate_no]', $user_data->inmatenumber);
		 * Yii::app()->request->cookies['confirm_payment[amount]'] = new CHttpCookie('confirm_payment[amount]', $_REQUEST['mc_gross']);
		 * Yii::app()->request->cookies['confirm_payment[name]'] = new CHttpCookie('confirm_payment[name]', $to_name);
		 * Yii::app()->request->cookies['confirm_payment[date]'] = new CHttpCookie('confirm_payment[date]', date("F j, Y"));
		 * Yii::app()->request->cookies['confirm_payment[inmate_name]'] = new CHttpCookie('confirm_payment[inmate_name]', $inmate_name);
		 * Yii::app()->user->setFlash('success', "Transaction successful");
		 * $this->redirect(array('confirmPayment'));
		 */
	}
	// /custom action PaymentNewCard
	public function actionPaymentNewCard() {
		if (empty ( $_POST )) {
			Yii::app ()->user->setFlash ( 'warning', "Something went wrong" );
			$this->redirect ( array (
					'search' 
			) );
		}
		require_once Yii::app ()->basePath . '/extensions/CIM/util.php';
		$this->layout = "registration-layout";
		$payment_data = unserialize ( $_POST ['payment_details'] );
		$amount = str_replace ( "$", "", $_POST ['price'] );
		// $amount = $_POST['User']['prepaidamount'];
		$so_block = $_POST ['so_block'];
		$gia_block = "4.00";
		$giatri_block = $_POST ['value_block'];
		$loggeduserid = $payment_data ['userid'];
		$inmateid = $payment_data ['inmateid'];
		$payment_data ['so_block'] = $_POST ['so_block'];
		
		Yii::app ()->request->cookies ['pay_for_inmate[user_type]'] = new CHttpCookie ( 'pay_for_inmate[user_type]', $payment_data ['user_type'] );
		Yii::app ()->request->cookies ['pay_for_inmate[userid]'] = new CHttpCookie ( 'pay_for_inmate[userid]', $payment_data ['userid'] );
		Yii::app ()->request->cookies ['pay_for_inmate[amount]'] = new CHttpCookie ( 'pay_for_inmate[amount]', $amount );
		Yii::app ()->request->cookies ['pay_for_inmate[inmateid]'] = new CHttpCookie ( 'pay_for_inmate[inmateid]', $payment_data ['inmateid'] );
		if ($payment_data ['user_type'] == "guest_user") {
			Yii::app ()->request->cookies ['pay_for_inmate[email_id]'] = new CHttpCookie ( 'pay_for_inmate[email_id]', $_POST ['guestuser'] ['email'] );
			Yii::app ()->request->cookies ['pay_for_inmate[to_name]'] = new CHttpCookie ( 'pay_for_inmate[to_name]', $_POST ['guestuser'] ['first_name'] . " " . $_POST ['guestuser'] ['last_name'] );
		}
		//
		if ($payment_data ['user_type'] == "app_user") {
			
			if ($_POST ['payment_type'] == "new_credit_card") {
				$user_data = InmateUser::model ()->find ( "customerid=$loggeduserid" );
				if (! empty ( $_POST ['guestuser'] ['email'] )) {
					$state = State::model()->findByPk($_POST ['guestuser'] ['state']);
					$address = $_POST ['guestuser'] ['address'] ;
					Yii::app ()->request->cookies ['confirm_payment[address]'] = new CHttpCookie ( 'confirm_payment[address]', $address );
					Yii::app ()->request->cookies ['confirm_payment[so_block]'] = new CHttpCookie ( 'confirm_payment[so_block]', $so_block );
					$command = Yii::app ()->db->createCommand ();
					$command->update ( 'inmate_customers', array (
							'contactnamefirst' => $_POST ['guestuser'] ['first_name'],
							'contactnamelast' => $_POST ['guestuser'] ['last_name'],
							'email' => $_POST ['guestuser'] ['email'],
							'city' => $_POST ['guestuser'] ['city'],
							'state' => $state->state_name,
							'zip' => $_POST ['guestuser'] ['zip'],
							'address' => $address 
					), 'customerid=:id', array (
							':id' => $loggeduserid 
					) );
				}
				
				$name = explode ( " ", $_POST ["CustomerCreditCard"] ['name_card'] );
				$fname = $lname = '';
				if (isset ( $name [0] ))
					$fname = $name [0];
				
				if (isset ( $name [1] ))
					$lname = $name [1];
				
				$cardtype = $_POST ["CustomerCreditCard"] ["cardtype"];
				
				$cardNO = $_POST ["CustomerCreditCard"] ['cardnumber'];
				Yii::app ()->request->cookies ['confirm_payment[card_no]'] = new CHttpCookie ( 'confirm_payment[card_no]', substr ( $_POST ["CustomerCreditCard"] ['cardnumber'], - 4 ) );
				$expiryDate = $_POST ["expiry_year"] . "-" . $_POST ["expiry_month"];
				// $expiryDate = $_POST["expiry_month"] . substr($_POST["expiry_year"], -2);
				$cvv = $_POST ["CustomerCreditCard"] ['csv'];
				if (empty ( $user_data->customer_profile_id ) && empty ( $user_data->customerPaymentProfileId )) {
					
					$pno = "";
					$state = State::model()->findByPk($_POST ['guestuser'] ['state']);
					if (empty ( $user_data->email )) {
						$user_email = $_POST ['guestuser'] ['email'];
						$address = $_POST ['guestuser'] ['address'];
					} else {
						$address = $user_data->address;
						$user_email = $user_data->email;
					}
					$city = $_POST ['guestuser'] ['city'];
					$state = State::model()->findByPk($_POST ['guestuser'] ['state']);
					$zip = $_POST ['guestuser'] ['zip'];
					// problem................
					
					$creditCardData = CimAccess::saveCreditCard ( "IU" . $loggeduserid, $user_email, $address, $city, $state->state_name, $zip, $cardNO, $expiryDate, $cvv, $fname, $lname, $pno );
					
					if (! empty ( $creditCardData ['profileId'] )) {
						
						$command = Yii::app ()->db->createCommand ();
						$command->update ( 'inmate_customers', array (
								'customer_profile_id' => $creditCardData ['profileId'],
								'customerPaymentProfileId' => $creditCardData ['paymentProfileId'],
								'customerAddressId' => $creditCardData ['shippingId'] 
						), 'customerid=:id', array (
								':id' => $loggeduserid 
						) );
						
						$transactionData = CimAccess::goForTransaction ( $creditCardData ['profileId'], $creditCardData ['paymentProfileId'], $creditCardData ['shippingId'], $amount, $giatri_block, $so_block, $gia_block );
						
						if ($transactionData ['msg'] == "failure") {
							
							Yii::app ()->user->setFlash ( 'warning', "Transaction is not successful" );
							$this->redirect ( array (
									'search' 
							) );
						}
					}
				} else {
					$address = $user_data->address;
					$city = $user_data->city;
					$state = $user_data->statedata->state_name;
					$zip = $user_data->zip;
					$creditCardData = CimAccess::updateCreditCard ( $user_data->customer_profile_id, $address, $city, $state, $zip, $user_data->customerPaymentProfileId, $cardNO, $expiryDate, $cvv, $fname, $lname );
					
					$transactionData = CimAccess::goForTransaction ( $user_data->customer_profile_id, $user_data->customerPaymentProfileId, $user_data->customerAddressId, $amount, $giatri_block, $so_block, $gia_block );
					
					if ($transactionData ['msg'] == "failure") {
						Yii::app ()->user->setFlash ( 'warning', "Transaction is not successful" );
						$this->redirect ( array (
								'search' 
						) );
					}
				}
			}
		} elseif ($payment_data ['user_type'] == "guest_user") {
			$cardtype = $_POST ["CustomerCreditCard"] ["cardtype"];
			$state = State::model()->findByPk($_POST ['guestuser'] ['state']);
			$cardNO = $_POST ["CustomerCreditCard"] ['cardnumber'];
			// $expiryDate = $_POST["expiry_month"] . substr($_POST["expiry_year"], -2);
			$expiryDate = $_POST ["expiry_month"] . substr ( $_POST ["expiry_year"] );
			Yii::app ()->request->cookies ['pay_for_inmate[card_no]'] = new CHttpCookie ( 'pay_for_inmate[card_no]', substr ( $_POST ["CustomerCreditCard"] ['cardnumber'], - 4 ) );
			$address = $_POST ['guestuser'] ['address'];
			Yii::app ()->request->cookies ['confirm_payment[address]'] = new CHttpCookie ( 'confirm_payment[address]', $address );
			// $expiryDate = "2016-02";
			$cvv = $_POST ["CustomerCreditCard"] ['csv'];
			$transactionData = CimAccess::payAsGuest ( $cardNO, $expiryDate, $cvv, $amount, $_POST );
			if ($transactionData ['msg'] == "failure") {
				Yii::app ()->user->setFlash ( 'warning', "Transaction is not successful" );
				$this->redirect ( array (
						'search' 
				) );
			}
			$data ['to_email'] = $_POST ['guestuser'] ['email'];
			$data ['to_name'] = $_POST ['guestuser'] ['first_name'] . " " . $_POST ['guestuser'] ['last_name'];
			$data ['fname'] = $_POST ['guestuser'] ['first_name'];
			$data ['lname'] = $_POST ['guestuser'] ['last_name'];
			// $data['email'] = $_POST['guestuser']['email'];
		}
		$transactionData ['transType'] = "Credit Card";
		$this->saveTransaction ( $payment_data, $transactionData, $data );
	}
	public function actionClearInmateSession() {
		Yii::app ()->session->destroy ();
	}
	public function saveTransaction($payment_data, $transactionData, $data = null) {
		
		$amount = $payment_data ['amount'];
		
		$so_block = $payment_data ['so_block'];
		
		// $loggeduserid = $payment_data['userid'];
		$inmateid = $payment_data ['inmateid'];
		
		$user_data = User::model ()->find ( "customerid= $inmateid" );
		$inmatepayerid = Yii::app ()->session ['payer_userid'];
		
		if (empty ( $data ))
			$inmate_user_data = InmateUser::model ()->find ( "customerid=$inmatepayerid" );
			// inmate user follow
		$userid = $user_data->customerid;
		$newprepaidamount = $user_data->prepaidamount + $amount;
		
		if (empty ( $data ))
			$to_email = $user_data->email;
		else
			$to_email = $data ['to_email'];
		if (empty ( $data )) {
			
			$to_name = $inmate_user_data->contactnamefirst . " " . $inmate_user_data->contactnamelast;
			$fname = $inmate_user_data->contactnamefirst;
			$lname = $inmate_user_data->contactnamelast;
			$address = $inmate_user_data->address;
			
			Yii::app ()->request->cookies ['confirm_payment[address]'] = new CHttpCookie ( 'confirm_payment[address]', $address );
			Yii::app ()->request->cookies ['confirm_payment[so_block]'] = new CHttpCookie ( 'confirm_payment[so_block]', $so_block );
		} else {
			$to_name = $data ['to_name'];
			$fname = $data ['fname'];
			$lname = $data ['lname'];
			// $email = $data['email'];
		}
		
		$datetime = date ( "Y-m-d H:i:s" );
		if (! empty ( $transactionData )) {
			
			if ($payment_data ['user_type'] == "guest_user")
				$inmatepayerid = 0;
				/*
			 * $command = Yii::app()->db->createCommand();
			 * $command->insert('inmate_payments', array('payerid' => $inmatepayerid,'inmate_id'=>$inmateid,'amount' => $amount, 'datetime' => $datetime, 'paymentmethod' => $transactionData['transType'], 'transaction_id' => $transactionData['transId'],'firstname' => $fname, 'lastname' => $lname,'email'=>$to_email));
			 * $command = Yii::app()->db->createCommand();
			 * $command->insert('customer_payment', array('memo' => $to_name ,'customerid' => $payment_data['inmateid'] ,'payerid' => $inmatepayerid, 'amount' => $amount, 'paymentdatetime' => $datetime, 'paymentmethod' => "Credit Card", 'invoicenumber' => $transactionData['transId']));
			 */
			$command = Yii::app ()->db->createCommand ();
			$command->insert ( 'inmate_payments', array (
					'amount' => $amount . "$$",
					'datetime' => $datetime,
					'paymentmethod' => $transactionData ['transType'],
					'transaction_id' => $transactionData ['transId'],
					'firstname' => $fname,
					'lastname' => $lname,
					'email' => $to_email,
					'inmate_id' => $payment_data ['inmateid'] 
			) );
			
			if ($transactionData ['transType'] == "Credit Card") {
				$cookie_data = Yii::app ()->request->cookies ['pay_for_inmate'];
				if (empty ( $transactionData ['transId'] )) {
					
					Yii::app ()->user->setFlash ( 'warning', "Transaction is not successful" );
					$this->redirect ( array (
							'search' 
					) );
				}
				if (! empty ( $cookie_data->value ['card_no'] ))
					$card_no = $cookie_data->value ['card_no'];
				else
					$card_no = 0;
			} else
				$card_no = 0;
			
			$command = Yii::app ()->db->createCommand ();
			$command->update ( 'customer', array (
					'prepaidamount' => $newprepaidamount 
			), 'customerid=:id', array (
					':id' => $userid 
			) );
			$command = Yii::app ()->db->createCommand ();
			$command->insert ( 'customer_payment', array (
					'payerid' => $inmatepayerid,
					'customerid' => $inmateid,
					'memo' => $to_name,
					'amount' => $amount,
					'paymentdatetime' => $datetime,
					'paymentmethod' => $transactionData ['transType'],
					'invoicenumber' => $transactionData ['invoiceNumber'] 
			) );
			$command = Yii::app ()->db->createCommand ();
			$command->insert ( 'customer_transactions', array (
					'customer_id' => $inmateid,
					'payerid' => $inmatepayerid,
					'amount' => $amount,
					'date' => $datetime,
					'transaction_type' => $transactionData ['transType'],
					'transaction_id' => $transactionData ['transId'],
					'card_no' => $card_no 
			) );
		}
		
		$inmate_name = $user_data->contactnamefirst . " " . $user_data->contactnamelast;
		$message = array (
				'inmate_no' => $user_data->inmatenumber,
				'amount' => $amount,
				'so_block' => $so_block,
				'name' => $to_name,
				'date' => date ( "F j, Y" ),
				'inmate_name' => $inmate_name,
				'address' => $address 
		);
		$subject = "Inmate Invoice";
		CimAccess::send_purchase_confirmation ( $to_email, $subject, $message );
		
		Yii::app ()->request->cookies ['confirm_payment[inmate_no]'] = new CHttpCookie ( 'confirm_payment[inmate_no]', $user_data->inmatenumber );
		Yii::app ()->request->cookies ['confirm_payment[amount]'] = new CHttpCookie ( 'confirm_payment[amount]', $amount );
		Yii::app ()->request->cookies ['confirm_payment[name]'] = new CHttpCookie ( 'confirm_payment[name]', $to_name );
		Yii::app ()->request->cookies ['confirm_payment[date]'] = new CHttpCookie ( 'confirm_payment[date]', date ( "F j, Y" ) );
		Yii::app ()->request->cookies ['confirm_payment[inmate_name]'] = new CHttpCookie ( 'confirm_payment[inmate_name]', $inmate_name );
		Yii::app ()->request->cookies ['confirm_payment[so_block]'] = new CHttpCookie ( 'confirm_payment[so_block]', $so_block );
		if ($transactionData ['transType'] == "Paypal") {
			
			Yii::app ()->request->cookies ['confirm_payment[address]'] = new CHttpCookie ( 'confirm_payment[address]', $payment_data ['address'] );
		}
		Yii::app ()->user->setFlash ( 'success', "Transaction successful" );
		
		$this->redirect ( array (
				'confirmPayment' 
		) );
	}
	public function actionPayForInmate() {
		$this->layout = "registration-layout";
		if (! empty ( $_POST )) {
			if (empty ( $_POST ['inmateid'] )) {
				Yii::app ()->user->setFlash ( 'warning', "Something went wrong" );
				$this->redirect ( array (
						'search' 
				) );
			}
			if ($_POST ['user_type'] == "app_user") {
				if ($_POST ['account_type'] == 1) {
					if (Yii::app ()->session ['payer_userid']) {
						$userid = Yii::app ()->session ['payer_userid'];
						$user_type = "app_user";
					} else {
						$username = $_POST ['LoginForm'] ['username'];
						$pwd = md5 ( $_POST ['LoginForm'] ['userpassword'] );
						$criteria = new CDbCriteria ();
						$criteria->condition = 'username=:username AND userpassword=:pwd';
						$criteria->params = array (
								':username' => $username,
								':pwd' => $pwd 
						);
						$inmate_user_data = InmateUser::model ()->find ( $criteria );
						// validate user input and redirect to the previous page if valid
						if (! empty ( $inmate_user_data )) {
							$userid = $inmate_user_data->customerid;
							Yii::app ()->session ['payer_userid'] = $inmate_user_data->customerid;
							Yii::app ()->session ['payer_name'] = $inmate_user_data->username;
							$user_type = "app_user";
						} else {
							Yii::app ()->user->setFlash ( 'success', "Invalid Username and Password" );
							$this->redirect ( array (
									'search' 
							) );
						}
					}
				}
				if ($_POST ['account_type'] == 0) {
					$command = Yii::app ()->db->createCommand ();
					// $command->insert('customer', array('username' => $_POST['signup']['username'], 'userpassword' => md5($_POST['signup']['userpassword']), 'status' => 2, 'role' => 'payer'));
					$command->insert ( 'inmate_customers', array (
							'username' => $_POST ['signup'] ['username'],
							'userpassword' => md5 ( $_POST ['signup'] ['userpassword'] ),
							'email' => '',
							'role' => 'payer' 
					) );
					$userid = Yii::app ()->db->getLastInsertID ();
					Yii::app ()->session ['payer_userid'] = $userid;
					Yii::app ()->session ['payer_name'] = $_POST ['signup'] ['username'];
					$user_type = "app_user";
				}
			}
			
			if ($_POST ['user_type'] == "guest_user") {
				$user_type = "guest_user";
				$userid = 0;
			}
			$payment_data ['user_type'] = $user_type;
			$payment_data ['userid'] = $userid;
			
			// $payment_data['blocks'] = $_POST['blocks'];
			$payment_data ['inmateid'] = $_POST ['inmateid'];
			Yii::app ()->session ['payment_data'] = $payment_data;
			$this->redirect ( array (
					'selectBlocks' 
			) );
			
			/*
			 * else {
			 * $data['inmateid'] = $_POST['inmateid'];
			 * $data['pay_amt'] = $_POST['pay_amt'];
			 * $this->render('select_payment', array('data' => $data));
			 * }
			 */
		} else {
			$this->redirect ( array (
					'search' 
			) );
		}
	}
	public function actionSelectBlocks() {
		$this->layout = "registration-layout";
		$payment_data = Yii::app ()->session ['payment_data'];
		if (empty ( $payment_data ))
			$this->redirect ( array (
					'search' 
			) );
		
		if (! empty ( $_POST )) {
			$payment_data = Yii::app ()->session ['payment_data'];
			$payment_data ['amount'] = $_POST ['amount'];
			$payment_data ['block'] = $_POST ['block'];
			$value = $_POST ['block'];
			switch ($value) {
				case 100 :
					$payment_data ['block2'] = 1;
					break;
				
				case 200 :
					$payment_data ['block2'] = 2;
					break;
				
				case 300 :
					$payment_data ['block2'] = 3;
					break;
				
				case 400 :
					$payment_data ['block2'] = 4;
					break;
				case 500 :
					$payment_data ['block2'] = 5;
					break;
				case 600 :
					$payment_data ['block2'] = 6;
					break;
				case 700 :
					$payment_data ['block2'] = 7;
					break;
				case 800 :
					$payment_data ['block2'] = 8;
					break;
				case 900 :
					$payment_data ['block2'] = 9;
					break;
				case 1000 :
					$payment_data ['block2'] = 10;
					break;
				case 1100 :
					$payment_data ['block2'] = 11;
					break;
				case 1200 :
					$payment_data ['block2'] = 12;
					break;
				case 1300 :
					$payment_data ['block2'] = 13;
					break;
				case 1400 :
					$payment_data ['block2'] = 14;
					break;
				case 1500 :
					$payment_data ['block2'] = 15;
					break;
				case 1600 :
					$payment_data ['block2'] = 16;
					break;
				case 1700 :
					$payment_data ['block2'] = 17;
					break;
				case 1800 :
					$payment_data ['block2'] = 18;
					break;
				case 1900 :
					$payment_data ['block2'] = 19;
					break;
				case 2000 :
					$payment_data ['block2'] = 20;
					break;
				case 2100 :
					$payment_data ['block2'] = 21;
					break;
				case 2200 :
					$payment_data ['block2'] = 22;
					break;
				case 2300 :
					$payment_data ['block2'] = 23;
					break;
				case 2400 :
					$payment_data ['block2'] = 24;
					break;
				case 2500 :
					$payment_data ['block2'] = 25;
					break;
				default :
					$payment_data ['block2'] = 0;
			}
			
			Yii::app ()->session ['payment_data'] = $payment_data;
			$this->redirect ( array (
					'selectPayment' 
			) );
		}
		
		$userid = Yii::app ()->session ['payer_userid'];
		if (! empty ( $userid )) {
			$user_data = InmateUser::model ()->find ( "customerid=$userid" );
		} else
			$user_data = array ();
		$this->render ( 'select_blocks', array (
				'payment_data' => $payment_data,
				'user_data' => $user_data 
		) );
	}
	public function actionSelectPayment() {
		$this->layout = "registration-layout";
		$payment_data = Yii::app ()->session ['payment_data'];
		$payment_data ['amount'] = $payment_data ['amount'];
		$model=new InmateUser();
		$countries = Countries::model()->findAll();
		$userid = $payment_data ['userid'];
		$user_data = InmateUser::model ()->find ( "customerid=$userid" );
		if ($payment_data ['user_type'] == "app_user" && ! empty ( $user_data->customer_profile_id )) {
			$creditCardData = CimAccess::getCreditCardData ( $user_data->customer_profile_id, $user_data->customerPaymentProfileId );
			$cardData ['firstname'] = '';
			$cardData ['lastname'] = '';
			$cardData ['cardnumber'] = '';
			
			if ("Ok" == $creditCardData->messages->resultCode) {
				$cardData ['firstname'] = $creditCardData->paymentProfile->billTo->firstName;
				$cardData ['lastname'] = $creditCardData->paymentProfile->billTo->lastName;
				$cardData ['cardnumber'] = $creditCardData->paymentProfile->payment->creditCard->cardNumber;
				Yii::app ()->request->cookies ['pay_for_inmate[card_no]'] = new CHttpCookie ( 'pay_for_inmate[card_no]', substr ( $creditCardData->paymentProfile->payment->creditCard->cardNumber, - 4 ) );
			}
		} else {
			$cardData = array ();
		}
		
		$this->render ( 'select_payment', array (
				'payment_data' => $payment_data,
				'user_data' => $user_data,
				'creditCardData' => $cardData,
				'countries' =>$countries,
				'model'=>$model
		) );
	}
	public function actionSearch() {
		$this->layout = "registration-layout";
		
		if (! empty ( $_POST )) {
			
			if (empty ( $_POST ['firstname'] ) && empty ( $_POST ['lastname'] ) && empty ( $_POST ['bopnumber'] )) {
				
				// $this->render('search_number',array('msg' => "Nothing to search"));
				Yii::app ()->user->setFlash ( 'warning', "Nothing to search" );
				$this->redirect ( array (
						'search' 
				) );
			} else {
				$params = array ();
				$flag = 0;
				$condition = '';
				if (! empty ( $_POST ['firstname'] )) {
					$condition .= 'contactnamefirst = :firstname';
					$params ['firstname'] = $_POST ['firstname'];
					$flag ++;
				}
				if (! empty ( $_POST ['lastname'] )) {
					if ($flag > 0) {
						$condition .= " AND";
					}
					$condition .= ' contactnamelast = :lastname';
					$params ['lastname'] = $_POST ['lastname'];
					$flag ++;
				}
				if (! empty ( $_POST ['bopnumber'] )) {
					if ($flag > 0) {
						$condition .= " AND";
					}
					$condition .= ' inmatenumber = :bopnumber';
					$params ['bopnumber'] = $_POST ['bopnumber'];
					$flag ++;
				}
				$criteria = new CDbCriteria ();
				$criteria->condition = $condition;
				$criteria->params = $params;
				// $inmateData = User::model()->find($criteria);
				$inmateData = User::model ()->findAll ( $condition, $params );
				
				// if (empty($inmateData) || empty($inmateData->inmatenumber)) {
				if (empty ( $inmateData )) {
					Yii::app ()->user->setFlash ( 'warning', "No result found" );
					$this->redirect ( array (
							'search' 
					) );
				} else {
					$this->render ( 'select_number', array (
							"inmate_numbers" => $inmateData 
					) );
				}
			}
		} else {
			$this->render ( 'search_number' );
		}
	}
	
	/**
	 * Displays a particular model.
	 * 
	 * @param integer $id
	 *        	the ID of the model to be displayed
	 */
	public function actionView($id) {
		$this->render ( 'view', array (
				'model' => $this->loadModel ( $id ) 
		) );
	}
	
	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate() {
		$model = new CustomerNumber ();
		
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		
		if (isset ( $_POST ['CustomerNumber'] )) {
			$model->attributes = $_POST ['CustomerNumber'];
			if ($model->save ())
				$this->redirect ( array (
						'view',
						'id' => $model->id 
				) );
		}
		
		$this->render ( 'create', array (
				'model' => $model 
		) );
	}
	
	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * 
	 * @param integer $id
	 *        	the ID of the model to be updated
	 */
	public function actionUpdate($id) {
		$model = $this->loadModel ( $id );
		
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		
		if (isset ( $_POST ['CustomerNumber'] )) {
			$model->attributes = $_POST ['CustomerNumber'];
			if ($model->save ())
				$this->redirect ( array (
						'view',
						'id' => $model->id 
				) );
		}
		
		$this->render ( 'update', array (
				'model' => $model 
		) );
	}
	
	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * 
	 * @param integer $id
	 *        	the ID of the model to be deleted
	 */
	public function actionDelete($id) {
		$this->loadModel ( $id )->delete ();
		
		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if (! isset ( $_GET ['ajax'] ))
			$this->redirect ( isset ( $_POST ['returnUrl'] ) ? $_POST ['returnUrl'] : array (
					'admin' 
			) );
	}
	
	/**
	 * Lists all models.
	 */
	public function actionIndex() {
		
		/*
		 * $dataProvider=new CActiveDataProvider('CustomerNumber');
		 * $this->render('index',array(
		 * 'dataProvider'=>$dataProvider,
		 * ));
		 */
		if (Yii::app ()->request->isAjaxRequest) {
			$this->renderPartial ( 'index' );
		} else {
			$this->render ( 'index' );
		}
	}
	public function actionStatusChange() {
		$data = CustomerNumber::model ()->findByPk ( $_POST ['id'] );
		$command = Yii::app ()->db->createCommand ();
		$command->update ( 'customer_number', array (
				'status' => $_POST ['status'] 
		), 'id=:id', array (
				':id' => $_POST ['id'] 
		) );
	}
	public function actionDetail() {
		
		/*
		 * $details = CustomerNumber::model()->findAll(array("order"=>"id"));
		 * $data["data"] = array();
		 * foreach ($details as $detail) {
		 * $data["data"][] = array($detail['type'],$detail['localnumber'],0,$detail['type'],0,0,$detail['starttime']);
		 * }
		 *
		 * echo json_encode($data);
		 */
		$userId = Yii::app ()->user->id;
		$customer = User::model ()->with ( 'customer_number' )->findByPk ( $userId );
		
		/*
		 * // retrieve the post's author: a relational query will be performed here
		 * $customer_numbers = $customer->number;
		 * echo "<pre>"; print_r($customer); echo "<pre />";
		 */
		
		$data ["data"] = array ();
		foreach ( $customer ['customer_number'] as $detail ) {
			switch ($detail ['ring_type']) {
				case 'us&ca' :
					$ring_type = "US or Canada Number";
					break;
				
				case 'int' :
					$ring_type = "International Number";
					break;
				
				default :
					$ring_type = "";
					break;
			}
			if ($detail ['status'] == 1) {
				$status_change = '<li><a href="javascript:void(0);" onclick="statusChange(' . $detail ['id'] . ',0)"><span class="glyphicon glyphicon-remove"></span>&nbsp;&nbsp;Disconnect</a></li>';
				$status = '<span class="label label-success">Active</span>';
			} else {
				continue;
				$status_change = '<li><a href="javascript:void(0);" onclick="statusChange(' . $detail ['id'] . ',1)"><span class="glyphicon glyphicon-ok"></span>&nbsp;&nbsp;Reconnect</a></li>';
				$status = '<span class="label label-danger">Pending</span>';
			}
			$html = '<div class="pull-right dropdown">
                        <a class="btn btn-default btn-ms dropdown-toggle" id="dLabel" role="button" data-toggle="dropdown" data-target="#" href="javascript: void(0);">Actions&nbsp;<span class="caret"></span></a>
                        <ul class="dropdown-menu" role="menu" aria-labelledby="dLabel">
                            <li><a href="#note-edit-model" data-toggle="modal" onclick="loadNoteData(' . $detail ['id'] . ')"><span class="glyphicon glyphicon-share-alt"></span>&nbsp;&nbsp;Edit Note</a></li>
                            <li><a href="#route-edit-model" data-toggle="modal" onclick="loadRouteData(' . $detail ['id'] . ')"><span class="glyphicon glyphicon-share-alt"></span>&nbsp;&nbsp;Change Routing</a></li>
                        ' . $status_change . '          
                        </ul>
                    </div>';
			$checkBox = "<input type='checkbox' value='{$detail['id']}' name='list[]' class='selectall' />";
			
			$data ["data"] [] = array (
					$checkBox,
					$detail ['type'],
					$detail ['localnumber'],
					$status,
					$ring_type,
					$detail ['pwdnumber'],
					$detail ['note'],
					date ( 'm/d/Y', strtotime ( $detail ['starttime'] ) ),
					$html 
			);
		}
		
		echo json_encode ( $data );
	}
	public function actionExportSelected() {
		if (! empty ( $_POST ['list'] )) {
			foreach ( $_POST ['list'] as $value ) {
				$ids [] = $value;
			}
		}
		
		$userid = Yii::app ()->user->getId ();
		Yii::Import ( 'application.extensions.ExportXLS.ExportXLS' );
		
		// Xls Header Row
		$headercolums = array (
				'Service Type',
				'Telephone Number',
				'Status',
				'Ring Type',
				'Destination',
				'Note',
				'Last Update' 
		);
		$criteria = new CDbCriteria ();
		if (! empty ( $_POST ['list'] )) {
			$criteria->addInCondition ( "id", $ids );
		}
		$telephone_numbers = Customernumber::model ()->findAll ( $criteria );
		
		// Xls Data
		
		foreach ( $telephone_numbers as $detail ) {
			$row = array (
					$detail ['type'],
					$detail ['localnumber'],
					0,
					$detail ['type'],
					0,
					0,
					$detail ['starttime'] 
			);
			$row1 [] = $row;
		}
		
		// Xls File Name
		$filename = 'telephone_numbers.xls';
		$xls = new ExportXLS ( $filename );
		$header = null;
		$xls->addHeader ( $headercolums );
		$xls->addRow ( $row1 );
		$xls->sendFile ();
		$this->redirect ( array (
				'customerNumber' 
		) );
	}
	public function actionGetRouteData() {
		if (! isset ( $_POST ) || empty ( $_POST ))
			$this->redirect ( array (
					'customerNumber/index' 
			) );
		
		$data = CustomerNumber::model ()->findByPk ( $_POST ['id'] );
		$html = '<form action="' . Yii::app ()->getBaseUrl () . '/index.php?r=customerNumber/updateRouteData" method="post">
                    <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h4 class="modal-title">Update Number Route - ' . $data ['localnumber'] . '</h4>
                                </div>
                   <div class="modal-body" style="height:107px;">
                   <div class="form-group">
                                    <label class="control-label col-lg-4">Ring Type</label>
                                        <div class="col-lg-6">
                                        <select id="ring_location" name="ring_location">
                                            <option value="">- Select -</option>
                                            <option value="us&ca">Ring to US Canada Number</option>
                                            <option value="int">Ring to International</option>
                                        </select>
                                        <input type="hidden" value="' . $data ['ring_type'] . '" name="saved_ring_location" />
                                            <p class="help-block"></p>
                                        </div>
                    </div>
                    <div class="form-group">
                                        <label class="control-label col-lg-4">Ring To Data</label>  
                                        <div class="col-lg-6">
                                        <input type="hidden" value="' . $data ['destination_number'] . '" name="saved_destination_number" />
                                        <input type="hidden" name="id" value="' . $_POST ['id'] . '" />
                                            <input type="text" id="destination_number" class="form-control" name="destination_number" value="">                 
                                            <p class="help-block"></p>
                                        </div>
                                    </div>
                    </div>
                    </div>
                    <div class="modal-footer">
                        <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                        <input type="submit" value="Update" name="yt0" class="btn btn-primary pull-right">  
                    </div>
                    </form>';
		echo $html;
	}
	public function actionGetNoteData() {
		if (! isset ( $_POST ) || empty ( $_POST ))
			$this->redirect ( array (
					'customerNumber/index' 
			) );
		
		$data = CustomerNumber::model ()->findByPk ( $_POST ['id'] );
		$html = '<form action="' . Yii::app ()->getBaseUrl () . '/index.php?r=customerNumber/updateNoteData" method="post">
                    <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h4 class="modal-title">Update Number Route - ' . $data ['localnumber'] . '</h4>
                                </div>
                   <div class="modal-body" style="height:107px;">                  
                    <div class="form-group">
                                        <label class="control-label col-lg-4">Note</label>  
                                        <div class="col-lg-6">
                                        <input type="hidden" name="id" value="' . $_POST ['id'] . '" />
                                            <input type="text" id="destination_number" class="form-control" name="note" value="' . $data ['note'] . '">                  
                                            <p class="help-block"></p>
                                        </div>
                                    </div>
                    </div>
                    </div>
                    <div class="modal-footer">
                        <button data-dismiss="modal" class="btn btn-default" type="button">Close</button>
                        <input type="submit" value="Update" name="yt0" class="btn btn-primary pull-right">  
                    </div>
                    </form>';
		echo $html;
	}
	public function actionUpdateRouteData() {
		if (! isset ( $_POST ) || empty ( $_POST ))
			$this->redirect ( array (
					'customerNumber/index' 
			) );
		
		if ($_POST ['destination_number'] == '') {
			$destination_number = $_POST ['saved_destination_number'];
		} else {
			$destination_number = $_POST ['destination_number'];
		}
		if (empty ( $_POST ['ring_location'] )) {
			$ring_location = $_POST ['saved_ring_location'];
		} else {
			$ring_location = $_POST ['ring_location'];
		}
		
		$command = Yii::app ()->db->createCommand ();
		$command->update ( 'customer_number', array (
				'destination_number' => $destination_number,
				'ring_type' => $ring_location 
		), 'id=:id', array (
				':id' => $_POST ['id'] 
		) );
		$this->redirect ( array (
				'customerNumber/index' 
		) );
	}
	public function actionUpdateNoteData() {
		if (! isset ( $_POST ) || empty ( $_POST ))
			$this->redirect ( array (
					'customerNumber/index' 
			) );
		$command = Yii::app ()->db->createCommand ();
		$command->update ( 'customer_number', array (
				'note' => $_POST ['note'] 
		), 'id=:id', array (
				':id' => $_POST ['id'] 
		) );
		$this->redirect ( array (
				'customerNumber/index' 
		) );
	}
	
	/**
	 * Manages all models.
	 */
	public function actionAdmin() {
		$model = new CustomerNumber ( 'search' );
		$model->unsetAttributes ();
		
		// clear any default values
		if (isset ( $_GET ['CustomerNumber'] ))
			$model->attributes = $_GET ['CustomerNumber'];
		
		$this->render ( 'admin', array (
				'model' => $model 
		) );
	}
	
	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * 
	 * @param integer $id
	 *        	the ID of the model to be loaded
	 * @return CustomerNumber the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id) {
		$model = CustomerNumber::model ()->findByPk ( $id );
		if ($model === null)
			throw new CHttpException ( 404, 'The requested page does not exist.' );
		return $model;
	}
	
	/*
	 * Performs the AJAX validation.
	 * @param CustomerNumber $model the model to be validated
	 */
	protected function performAjaxValidation($model) {
		if (isset ( $_POST ['ajax'] ) && $_POST ['ajax'] === 'customer-number-form') {
			echo CActiveForm::validate ( $model );
			Yii::app ()->end ();
		}
	}
}
