<?php

class FacilityLocationController extends Controller
{
	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('payByPaypal','invoice','payForBlock','getBlockPrice','findInmateNumber','getNumber','GetSetupDetails','create','update','detail'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actionAdmin()
	{
		$this->render('admin');
	}

	public function actionCreate()
	{
		$this->render('create');
	}

	public function actionIndex()
	{
		$data=FacilityLocation::model()->findAll();
		$list = CHtml::listData($data, 'id', 'facility');
		Yii::app()->request->cookies['buy_number[referel_url]'] = new CHttpCookie('buy_number[referel_url]', 'facilityLocation');
		// configure cookie to store service type		
		// Yii::app()->request->cookies['buy_number[service_type]'] = new CHttpCookie('buy_number[service_type]', 'Inmate');
		Yii::app()->request->cookies['buy_number[service_type]'] = new CHttpCookie('buy_number[service_type]', 'inmate');
		if(Yii::app()->request->isAjaxRequest) {
		$this->renderPartial('localnumber',array('list'=>$list,));
		}else {
			$this->render('localnumber',array('list'=>$list,));
		}
	}
	
	public function actionGetNumber()
	{	
		if(!isset($_POST) || empty($_POST))
			$this->redirect(array('customerNumber/index'));

		Yii::app()->request->cookies['buy_number[selected_number]'] = new CHttpCookie('buy_number[selected_number]', $_POST['selected_number']);
		$selected_num=$_POST['selected_number'];
		$model=new FacilityLocation;
		if(Yii::app()->request->isAjaxRequest) {
		$this->renderPartial('getnumber',array('model'=>$model,'selected_num'=>$selected_num));
		}else {
			$this->render('getnumber',array('model'=>$model,'selected_num'=>$selected_num));
		}
	}

	public function actionGetBlockPrice() 
	{
		//echo $_POST['selected_num'];
		//echo $_POST['ring_location'];
		//echo $_POST['number'];
		if(!isset($_POST) || empty($_POST))
			$this->redirect(array('customerNumber/index'));

		$cookie = Yii::app()->request->cookies['buy_number']->value; 
		Yii::app()->request->cookies['buy_number[ring_location]'] = new CHttpCookie('buy_number[ring_location]', $_POST['ring_location']);
		Yii::app()->request->cookies['buy_number[destination_number]'] = new CHttpCookie('buy_number[destination_number]', $_POST['destination_number']);
		$model=new FacilityLocation;
		
		if(Yii::app()->request->isAjaxRequest) {
		$this->renderPartial('getblockprice',array('model'=>$model,'selected_num' => $cookie['selected_number'],'referel_url' => $cookie['referel_url']));
		}else {
			$this->render('getblockprice',array('model'=>$model,'selected_num' => $cookie['selected_number'],'referel_url' => $cookie['referel_url']));
		}

	}
	function actionInvoice() { 

		if(!isset($_POST) || empty($_POST))
			$this->redirect(array('customerNumber/index'));

		Yii::app()->request->cookies['buy_number[service_type]'] = new CHttpCookie('buy_number[service_type]', $_POST['service_type']);
		$service_type_no = $_POST['service_type']."_selected_number";
		Yii::app()->request->cookies['buy_number[selected_number]'] = new CHttpCookie('buy_number[selected_number]', $_POST[$service_type_no]);
		Yii::app()->request->cookies['buy_number[ring_location]'] = new CHttpCookie('buy_number[ring_location]', $_POST['ring_location']);
		Yii::app()->request->cookies['buy_number[destination_number]'] = new CHttpCookie('buy_number[destination_number]', $_POST['destination_number']);
		Yii::app()->request->cookies['buy_number[prepaid_amount]'] = new CHttpCookie('buy_number[prepaid_amount]', $_POST["prepaidamount"]);
		
		
		$userid=Yii::app()->user->getId();
		$model1= new CustomerCreditCard;
		$model2 = new User;	
		$credit_card_details=array();
		$credit_card_details=CustomerCreditCard::model()->find("customerid=$userid");

		$userid=Yii::app()->user->getId(); 
		$userdetails=Dashboard::model()->find("customerid=$userid");	
		
		$postData['prepaidamount'] = $_POST["prepaidamount"];		

	//	$cookie = Yii::app()->request->cookies['buy_number']->value; 
		if(Yii::app()->request->isAjaxRequest) {
		$this->renderPartial('invoice',array('userdetails'=>$userdetails,'credit_card_details'=>$credit_card_details,'model1'=>$model1,'model2'=>$model2,'choosen' => $cookie));
		}else {
			$this->render('invoice',array('userdetails'=>$userdetails,'credit_card_details'=>$credit_card_details,'model1'=>$model1,'model2'=>$model2,'postData' =>  $postData));
		}

	}
	public function actionPayForBlock() {	 
	
		
		if (!empty($_POST)) {
			
			$minutes_price = str_replace("$", "", $_POST['price']);
			Yii::app()->request->cookies['buy_number[service_type]'] = new CHttpCookie('buy_number[service_type]', ucfirst($_POST['service_type']));
			$service_type_no = $_POST['service_type']."_selected_number";
			// Yii::app()->request->cookies['buy_number[selected_number]'] = new CHttpCookie('buy_number[selected_number]', $_POST[$service_type_no]);
			Yii::app()->request->cookies['buy_number[selected_number]'] = new CHttpCookie('buy_number[selected_number]', $service_type_no);
			Yii::app()->request->cookies['buy_number[ring_location]'] = new CHttpCookie('buy_number[ring_location]', $_POST['ring_location']);
			Yii::app()->request->cookies['buy_number[destination_number]'] = new CHttpCookie('buy_number[destination_number]', $_POST['destination_number']);
			
			Yii::app()->request->cookies['buy_number[location]'] = new CHttpCookie('buy_number[location]', $_POST['location']);
			
			Yii::app()->request->cookies['buy_number[prepaid_amount]'] = new CHttpCookie('buy_number[prepaid_amount]', $_POST["prepaidamount"]);
			
			Yii::app()->request->cookies['buy_number[inmate_selected_number]'] = new CHttpCookie('buy_number[inmate_selected_number]', $_POST["inmate_selected_number"]);
			if ($_POST['service_type'] == 'inmate') {
				//echo $_POST['service_type'];exit();
				Yii::app()->request->cookies['buy_number[first_name]'] = new CHttpCookie('buy_number[first_name]', $_POST['first_name']);
				Yii::app()->request->cookies['buy_number[last_name]'] = new CHttpCookie('buy_number[last_name]', $_POST['last_name']);
				Yii::app()->request->cookies['buy_number[minutes_price]'] = new CHttpCookie('buy_number[minutes_price]', $minutes_price);
				Yii::app()->request->cookies['buy_number[minutes]'] = new CHttpCookie('buy_number[minutes]', $_POST['block']);
			}
		
		$selected_number = $service_type_no;
		$amount = $_POST["User"]["prepaidamount"];
			
		$customer_profile_id=0;
		$customerPaymentProfileId=0;
		$customerAddressId=0;
		
			// $so_block     = $_POST['so_block'];
			 $gia_block    = "4.00";
			 $giatri_block =  $_POST['block'];
			switch ($giatri_block) {
				case 100:
				    $so_block = 1;
				break;
			 
				case 200:
				    $so_block = 2;
				break;
			 
				case 300:
				    $so_block = 3;
				break;
			   
			    case 400:
				    $so_block = 4;
				break;
			    case 500:
				    $so_block = 5;
				break;
			    case 600:
				    $so_block = 6;
				break;
			    case 700:
				    $so_block = 7;
				break;
			    case 800:
				    $so_block = 8;
				break;
			    case 900:
				    $so_block = 9;
				break;
			    case 1000:
				    $so_block = 10;
				break;
				case 1100:
				    $so_block = 11;
				break;
			 
				case 1200:
				    $so_block = 12;
				break;
			 
				case 1300:
				    $so_block = 13;
				break;
			   
			    case 1400:
				    $so_block = 14;
				break;
			    case 1500:
				    $so_block = 15;
				break;
			    case 1600:
				    $so_block = 16;
				break;
			    case 1700:
				    $so_block = 17;
				break;
			    case 1800:
				    $so_block = 18;
				break;
			    case 1900:
				    $so_block = 19;
				break;
			    case 2000:
				    $so_block = 20;
				break;
				case 2100:
				    $so_block = 21;
				break;
			    case 2200:
				    $so_block = 22;
				break;
			    case 2300:
				    $so_block = 23;
				break;
			    case 2400:
				    $so_block = 24;
				break;
			    case 2500:
				    $so_block = 25;
				break;
				default:
				   $so_block = 0;
			}
			//$payment_data['so_block']=$_POST['so_block'];
		
		$userid=Yii::app()->user->getId(); 
		
		$user = Dashboard::model()->find("customerid=$userid"); 
		if(!empty($user->accountcode))
		{
			$accountcode = $user->accountcode;
		}else{
			$accountcode = "";
		}
		
		$datas=Dashboard::model()->find("customerid=$userid");	
		
	
		//for free inmate number
		if ($_POST['inmate_status'] == 0) {
			
				$minutes = $_POST['block'];
				$command = Yii::app()->db->createCommand();
				$command->insert('customer_number', array(
			    'customerid'=> $userid,
			    'firstname'=>$_POST['first_name'],
			    'lastname' => $_POST['last_name'],
			    'localnumber' => $_POST['inmate_selected_number'],
			    'pwdnumber' => $_POST['destination_number'],
			    'type' => ucfirst($_POST['service_type']),
			    'starttime' => date("Y-m-d H:i:s"),
			    'ring_type' => $_POST['ring_location']			    			   
				));
			//////////insert opensips database////////////
				$command = Yii::app()->db2->createCommand();
				$command->insert('opensips.dr_rules', array(
			    'groupid'=> 0,
			    'prefix'=>$_POST['inmate_selected_number'],
			    'priority' => 0,
			    'gwlist' => "",
			    'attrs' => $_POST['destination_number'],
			    'description' => $accountcode
			    			   
				));
			// $sql_1 = "insert into opensips.dr_rules (groupid,prefix,priority, gwlist,attrs,description )  "
                    // . " SELECT '0', localnumber, '0', concat('#' , carrierid), pwdnumber, accountcode "
                    // . "FROM customer_number WHERE customerid = '" . $_POST['customerid'] . "'";
				
			///////update facility_numberpool//////
		
			  $command = Yii::app()->db->createCommand();
			  $command->update('facility_numberpool', array( 'status' => 1),
			  'pnumber=:pnumber AND location=:location',array(':pnumber'=>$_POST['inmate_selected_number'], ':location'=>$_POST['location']));
		
			$sql1 ="SELECT inmatenumber FROM `customer` WHERE `contactnamefirst`='".$_POST['first_name']."' and `inmatenumber` = '".$_POST['bpo_number']."' and `contactnamelast`='".$_POST['last_name']."'";
		   $rawData = Yii::app()->db->createCommand($sql1)->queryAll();
		
		   if(!empty($rawData)){
			 $command = Yii::app()->db->createCommand();
			 $command->update('customer', array(
			 'inmatenumber' => $_POST['bpo_number'],
			 'location' => $_POST['location'],
			 'total_minutes'=>$datas['total_minutes']+$minutes,	
			 'prepaidamount'=>$datas['PrepaidAmount']+$minutes_price,			
			), 'customerid=:id', array(':id'=>$userid));
			$this->redirect(array('customerNumber/index')); 
		   }else{
				////////add new/////////
				$command = Yii::app()->db->createCommand();
				$command->insert('customer', array(
			    'inmatenumber'=> $_POST['bpo_number'],
			    'contactnamefirst'=>$_POST['first_name'],
			    'contactnamelast' => $_POST['last_name'],
			    'location' => $_POST['location']
			   	
				));
				/////////update customer with current userid//////////
				 $command = Yii::app()->db->createCommand();
				 $command->update('customer', array(
				 'total_minutes'=>$datas['total_minutes']+$minutes,	
				 'prepaidamount'=>$datas['PrepaidAmount']+$minutes_price,			
				 ), 'customerid=:id', array(':id'=>$userid));
				$this->redirect(array('customerNumber/index')); 
		   }
			
		}
		require_once Yii::app()->basePath . '/extensions/CIM/util.php';
		if($_POST['payment_type'] == "paypal") {
			
			//define( 'SSL_URL', 'https://www.paypal.com/cgi-bin/webscr' );
			define( 'SSL_URL', 'https://www.paypal.com/cgi-bin/webscr' );
			define( 'SSL_SAND_URL', 'https://www.sandbox.paypal.com/cgi-bin/webscr' );
			$data=array(
			//'merchant_email'=>'lmsmerchant@gmail.com',	
			'merchant_email'=>'ricky.keele@digitalipvoice.com',	
			
			'product_name'=>'Demo Product',
			//'amount'=>4.00,
			'amount'=>$amount,
			
			'currency_code'=>'USD',
			'thanks_page'=>"http://".$_SERVER['HTTP_HOST'].Yii::app()->createUrl("facilityLocation/payByPaypal"),
			'notify_url'=>"http://".$_SERVER['HTTP_HOST'].Yii::app()->createUrl("customerNumber/index"),
			//'cancel_url'=> "http://".$_SERVER['HTTP_HOST'].Yii::app()->createUrl("customerNumber/index"),
			
			 'cancel_url'=>"http://".$_SERVER['HTTP_HOST'].Yii::app()->createUrl('order/index&fname='.$_POST['first_name'].'&lname='.$_POST['last_name'].'&bpo_number='.$_POST['bpo_number'].'&location='.$_POST['location'].'&inmatenumber='.$_POST['inmate_selected_number'].'&ring_location='.$_POST['ring_location'].'&destination_number='.$_POST['destination_number'].'&block='.$_POST['block'].'&price='.$minutes_price),
			'paypal_mode'=>true,
			
			);

			$action = '';
			 
			$action = SSL_URL;

			$form = '';

			$form .= '<form name="frm_payment_method" action="' . $action . '" method="post">';
			 $form .= '<input type="hidden" name="business" value="' . $data['merchant_email'] . '" />';
			 // Instant Payment Notification & Return Page Details /
			 $form .= '<input type="hidden" name="notify_url" value="' . $data['notify_url'] . '" />';
			 $form .= '<input type="hidden" name="cancel_return" value="' . $data['cancel_url'] . '" />';
			 $form .= '<input type="hidden" name="return" value="' . $data['thanks_page'] . '" />';
			 $form .= '<input type="hidden" name="rm" value="2" />';
			 // Configures Basic Checkout Fields -->
			
			  $form .= '<input type="hidden" name="lc" value="" />';
			//  $form .= '<input type="hidden" name="address_override" value="1">';
			  
			 $form .= '<input type="hidden" name="no_shipping" value="1" />';
			 $form .= '<input type="hidden" name="no_note" value="1" />';
			 // <input type="hidden" name="custom" value="localhost" />-->
			 $form .= '<input type="hidden" name="currency_code" value="' . $data['currency_code'] . '" />';
			 $form .= '<input type="hidden" name="page_style" value="paypal" />';
			 $form .= '<input type="hidden" name="charset" value="utf-8" />';
			 $form .= '<input type="hidden" name="item_name" value="' . $data['product_name'] . '" />';
			 $form .= '<input type="hidden" value="_xclick" name="cmd"/>';
			 $form .= '<input type="hidden" name="amount" value="' . $amount . '" />';			 
			 $form .= '<script>';
			 $form .= 'setTimeout("document.frm_payment_method.submit()", 2);';
			 $form .= '</script>';
			 $form .= '</form>';
			 $this->render('payByPaypal',array('form'=>$form));

		}
		if($_POST['payment_type'] == "new_credit_card") {
			 $user_data = User::model()->find("customerid=$userid"); 
			$name = explode(" ", $_POST["CustomerCreditCard"]['name_card']);
			$fname = $lname = '';
			if(isset($name[0]))
				$fname = $name[0];

			if(isset($name[1]))
				$lname = $name[1];			
			
			
			$cardtype = $_POST["CustomerCreditCard"]["cardtype"];		
			
			$cardNO = $_POST["CustomerCreditCard"]['cardnumber'];
			$expiryDate =  $_POST["expiry_year"]."-".$_POST["expiry_month"];
			//$expiryDate = "2016-02";
			$cvv = $_POST["CustomerCreditCard"]['csv'];	
			if(empty($user_data->customer_profile_id) && empty($user_data->customerPaymentProfileId)) { 
				$user_email = $user_data->email;
				$pno = $user_data->contactnumber;
				$address = $user_data->address1;
				
				$city = $user_data->city;
				$state = $user_data->state;
				$zip = $user_data->zip;
				$address .=", ".$city.", ".$state.", ".$zip;
				$creditCardData = CimAccess::saveCreditCard("IU".$userid,$user_email,$address, $city, $state, $zip,$cardNO,$expiryDate,$cvv,$fname,$lname,$pno);
				if(!empty($creditCardData)) {
					$command = Yii::app()->db->createCommand();
					$command->update('customer', array(						
						'customer_profile_id'=>$creditCardData['profileId'],
						'customerPaymentProfileId'=>$creditCardData['paymentProfileId'],
						'customerAddressId'=>$creditCardData['shippingId']
					), 'customerid=:id', array(':id'=>$userid));
					$transactionData = CimAccess::goForTransaction($creditCardData['profileId'],$creditCardData['paymentProfileId'],$creditCardData['shippingId'],$amount,$giatri_block, $so_block, $gia_block);

					if( $transactionData['msg'] == "failure") {
						$this->redirect(array('order/failure'));
					}
				}
			}else {		
				$creditCardData = CimAccess::updateCreditCard($user_data->customer_profile_id,$user_data->customerPaymentProfileId,$cardNO,$expiryDate,$cvv,$fname,$lname);

				$transactionData = CimAccess::goForTransaction($user_data->customer_profile_id,$user_data->customerPaymentProfileId,$user_data->customerAddressId,$amount,$giatri_block, $so_block, $gia_block);

				if( $transactionData['msg'] == "failure") {
				$this->redirect(array('order/failure'));
				}
			}			
			
		}

		if($_POST['payment_type'] == "existing_credit_card") {

			 $user_data = User::model()->find("customerid=$userid"); 
			 $transactionData = CimAccess::goForTransaction($user_data->customer_profile_id,$user_data->customerPaymentProfileId,$user_data->customerAddressId,$amount,$giatri_block, $so_block, $gia_block);			
			if( $transactionData['msg'] == "failure") {
				$this->redirect(array('order/failure'));
			}
					
		
		}
		$datetime = date("Y-m-d H:i:s");
			$command = Yii::app()->db->createCommand();
			$command->insert('customer_payment', array(
			'customerid'=>$userid,	
			'amount'=>$amount,		
			'paymentdatetime' => $datetime,
			'paymentmethod' => "Credit Card",
			'invoicenumber' => $transactionData['transId']
			));

			$command = Yii::app()->db->createCommand();
			if($_POST['service_type'] == 'inmate') {
				$minutes = $_POST['block'];
				$command->insert('customer_number', array(
			    'customerid'=> $userid,
			    'firstname'=>$_POST['first_name'],
			    'lastname' => $_POST['last_name'],
			    'localnumber' => $_POST['inmate_selected_number'],
			    'pwdnumber' => $_POST['destination_number'],
			    'type' => ucfirst($_POST['service_type']),
			    'starttime' => $datetime,
			    'ring_type' => $_POST['ring_location'],
			    'status' => 1	    			   
				));
				$customer_number_id = new CHttpCookie('buy_number[customer_number_id]', Yii::app()->db->lastInsertID);
				//////////insert opensips database////////////
				$command = Yii::app()->db2->createCommand();
				$command->insert('opensips.dr_rules', array(
			    'groupid'=> 0,
			    'prefix'=>$_POST['inmate_selected_number'],
			    'priority' => 0,
			    'gwlist' => "",
			    'attrs' => $_POST['destination_number'],
			    'description' => $accountcode
			    			   
				));
				
				$command = Yii::app()->db->createCommand();
			    $command->update('facility_numberpool', array( 'status' => 1),
			    'pnumber=:pnumber AND location=:location',array(':pnumber'=>$_POST['inmate_selected_number'], ':location'=>$_POST['location']));

				$sql2 ="SELECT `inmatenumber` FROM `customer` WHERE `contactnamefirst`='".$_POST['first_name']."' and `inmatenumber` = '".$_POST['bpo_number']."' and contactnamelast='".$_POST['last_name']."'";
				$rawData2 = Yii::app()->db->createCommand($sql2)->queryAll();
				   if(!empty($rawData2)){
					 $command = Yii::app()->db->createCommand();
					 $command->update('customer', array(
					
					 'total_minutes'=>$datas['total_minutes']+$minutes,	
					 'prepaidamount'=>$datas['PrepaidAmount']+$minutes_price,			
					), 'customerid=:id', array(':id'=>$userid));
					$this->redirect(array('customerNumber/index')); 
				   }else{
						////////add new/////////
						$command = Yii::app()->db->createCommand();
						$command->insert('customer', array(
						'inmatenumber'=> $_POST['bpo_number'],
						'contactnamefirst'=>$_POST['first_name'],
						'contactnamelast' => $_POST['last_name'],
						'location' => $_POST['location']
						
						));

						/////////update customer with current userid//////////
						 $command = Yii::app()->db->createCommand();
						 $command->update('customer', array(
						 'total_minutes'=>$datas['total_minutes']+$minutes,	
						 'prepaidamount'=>$datas['PrepaidAmount']+$minutes_price,			
						 ), 'customerid=:id', array(':id'=>$userid));
						$this->redirect(array('customerNumber/index')); 
				   }
	
			}else {
				$minutes = 0;
				$command->insert('customer_number', array(
			    'customerid'=> $userid,			    
			    'localnumber' => $selected_number,
			    'type' => ucfirst($_POST['service_type']),
			    'starttime' => $datetime,
			    'ring_type' => $_POST['ring_location'],
			    'pwdnumber' => $_POST['destination_number'],
			    'status' => 1		    
				));
				
				//////////insert opensips database////////////
				$command = Yii::app()->db2->createCommand();
				$command->insert('opensips.dr_rules', array(
			    'groupid'=> 0,
			    'prefix'=>$_POST['inmate_selected_number'],
			    'priority' => 0,
			    'gwlist' => "",
			    'attrs' => $_POST['destination_number'],
			    'description' => $accountcode
			    			   
				));
				$customer_number_id = new CHttpCookie('buy_number[customer_number_id]', Yii::app()->db->lastInsertID);
			}	

		
			$cookie = Yii::app()->request->cookies['buy_number']->value; 
			$filePath = CimAccess::saveInvoicePdf($_POST['service_type'],$selected_number,$_POST['ring_location'],$_POST['destination_number'],$_POST["prepaidamount"]);
			$command = Yii::app()->db->createCommand();
			$command->insert('customernew_invoices', array(
			    'customer_id'=> $userid,
			    'customer_invoice_file'=>$filePath,
			    'start_date' => date("Y-m-d"),
			    'end_date' => date("Y-m-d"),
			    'update_date' => date("Y-m-d"),
			    'customer_number_id' => $customer_number_id
			    ));
		$this->redirect(array('customerNumber/index'));
		}else {
		$model = new User;
		$userdetails = Account::model()->find("customerid=$userid");
		if(Yii::app()->request->isAjaxRequest) {
			$this->renderPartial('account',array('userdetails'=>$userdetails,'model'=>$model));
		}else {
			$this->render('account',array('userdetails'=>$userdetails,'model'=>$model));
		}
	}
	}

	public function actionPayByPaypal() {
		
		// echo "<pre>";
		// print_r($_REQUEST);
		// echo "</pre>";
		//exit;
		
		$cookie = Yii::app()->request->cookies['buy_number']->value;
		
		$userid=Yii::app()->user->getId(); 
		
		$user = Dashboard::model()->find("customerid=$userid"); 
		if(!empty($user->accountcode))
		{
			$accountcode = $user->accountcode;
		}else{
			$accountcode = "";
		}
		
		$datas=Dashboard::model()->find("customerid=$userid");		
		$command = Yii::app()->db->createCommand();
		$datetime = date("Y-m-d H:i:s");
			$command = Yii::app()->db->createCommand();
			$command->insert('customer_transactions', array(
			'customer_id'=>$userid,	
			'amount'=>$_REQUEST['mc_gross'],		
			'date' => $datetime,
			'transaction_type' => "Paypal",
			'transaction_id' => $_REQUEST['txn_id']	,
			'payerid' => 0,	
			'card_no' =>0
			));
		
		//if ($_REQUEST['buy_number']['service_type'] == 'inmate') {
		if ($cookie['service_type'] == 'Inmate') {
			
			$cookie = Yii::app()->request->cookies['buy_number']->value;
			$command->insert('customer_number', array(
			    'customerid'=> $userid,			
			    //'firstname'=>$_REQUEST['buy_number']['first_name'],
				'firstname'=>$cookie['first_name'],
			    //'lastname' => $_REQUEST['buy_number']['last_name'], 
				'lastname' => $cookie['last_name'], 				
			    //'localnumber' => $_REQUEST['buy_number']['selected_number'],
				'localnumber' => $cookie['inmate_selected_number'],
			    //'pwdnumber' => $_REQUEST['buy_number']['destination_number'],//$_REQUEST['buy_number']['bpo_number'],
				'pwdnumber' => $cookie['destination_number'],//$_REQUEST['buy_number']['bpo_number'],
			    //'type' => $_REQUEST['buy_number']['service_type'],
				'type' => $cookie['service_type'],
			    'starttime' => $datetime,
			    //'ring_type' => $_REQUEST['buy_number']['ring_location'],
				'ring_type' => $cookie['ring_location'],
			    'status' => 1		  
			));
			//////////insert opensips database////////////
				$command = Yii::app()->db2->createCommand();
				$command->insert('opensips.dr_rules', array(
			    'groupid'=> 0,
			    'prefix'=>$cookie['inmate_selected_number'],
			    'priority' => 0,
			    'gwlist' => "",
			    'attrs' =>  $cookie['destination_number'],
			    'description' => $accountcode
			    			   
				));
			$customer_number_id = new CHttpCookie('buy_number[customer_number_id]', Yii::app()->db->lastInsertID);
			$command = Yii::app()->db->createCommand();
			$command->update('customer', array(
			//'inmatenumber' => $_POST['bpo_number'],
			'location'		 => $cookie['location'],
			'total_minutes'=>$datas['total_minutes']+$cookie['minutes'],	
			'prepaidamount'=>$datas['PrepaidAmount']+$cookie['minutes_price'],		
			), 'customerid=:id', array(':id'=>$userid));
		}else {
				$command->insert('customer_number', array(
			    'customerid'=> $userid,						       
			    'localnumber' => $cookie['inmate_selected_number'],
				//'localnumber' => $cookie['selected_number'],
			    'type' => $cookie['service_type'],
			    'starttime' => $datetime,
			    'ring_type' => $cookie['ring_location'],
			    'pwdnumber' => $cookie['destination_number']
			));
			
			//////////insert opensips database////////////
				$command = Yii::app()->db2->createCommand();
				$command->insert('opensips.dr_rules', array(
			    'groupid'=> 0,
			    'prefix'=>$cookie['inmate_selected_number'],
			    'priority' => 0,
			    'gwlist' => "",
			    'attrs' =>  $cookie['destination_number'],
			    'description' => $accountcode
			    			   
				));
			$customer_number_id = new CHttpCookie('buy_number[customer_number_id]', Yii::app()->db->lastInsertID);
		}
		// q->off	
		$filePath = CimAccess::saveInvoicePdf($cookie['service_type'],$cookie['selected_number'],$cookie['ring_location'],$cookie['destination_number'],$_REQUEST['txn_id']);
			$command = Yii::app()->db->createCommand();
			$command->insert('customernew_invoices', array(
			    'customer_id'=> $userid,
			    'customer_invoice_file'=>$filePath,
			    'start_date' => date("Y-m-d"),
			    'end_date' => date("Y-m-d"),
			    'update_date' => date("Y-m-d"),
			    'customer_number_id' => $customer_number_id
			    ));
			
			$this->redirect(array('customerNumber/index'));

	}
	public function actionFindInmateNumber()
	{	
		$datas=FacilityNumberpool::model()->findAllByAttributes(array('location' =>$_POST['location'], 'status'=>0));
		$option = "<option value=''>- Select -</option>";
		if(!empty($datas))
		{
			
						foreach($datas as $data)
						{							
							$option .= "<option value=".$data['pnumber'].">".$data['pnumber']."</option>";
						}

		}
		echo $option;
	}
	
	public function actionGetSetupDetails()
	{	
		echo '<div class="alert alert-info"><b>Selected Number:</b> '.$_POST['num'].' <b>Setup Fee:</b> $3.50 <b>Monthly Fee:</b> $1.50 <b>Per Minute Fee:</b> $0.03</div>';
	}

	public function actionUpdate()
	{
		$this->render('update');
	}

	public function actionView()
	{
		$this->render('view');
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return CustomerNumber the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=CustomerNumber::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CustomerNumber $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='customer-number-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}